<?php
/**
 * Module Tour settings page. 
 */
function _thtt_transfer_admin_price_add_form() {
	// Get the default settings for all slideshows
	$settings = variable_get('thtt_transfer_settings', array());
	
	//Init dropdown list
	$destinationOption = array();
	$result = db_select('thtt_m_transfer_destination','a')
	->fields('a')
	->execute();
	foreach($result as $itemTmp) {
		$destinationOption[$itemTmp->dest_id] = t($itemTmp->dest_name);
	}
	
	$typeOption = array();
	$result = db_select('thtt_m_transfer_type','a')
	->fields('a')
	->execute();
	foreach($result as $itemTmp) {
		$typeOption[$itemTmp->type_id] = t($itemTmp->type_name);
	}
	
	// Build the form
	$form['fare_from'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer from'),
			'#title'          => t('Transfer from'),
			'#type'           => 'select',
			'#options'        => $destinationOption,
    		'#required' => TRUE,
	);
	$form['fare_to'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer to'),
			'#title'          => t('Transfer to'),
			'#type'           => 'select',
			'#options'        => $destinationOption,
    		'#required' => TRUE,
	);
	$form['fare_type'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer type'),
			'#title'          => t('Transfer type'),
			'#type'           => 'select',
			'#options'        => $typeOption,
    		'#required' => TRUE,
	);
	$form['fare_price'] = array(
			'#default_value'  => '',
			'#description'    => t('Price of transfer (THB)'),
			'#title'          => t('Price of transfer'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('  Save  '),
			'#type'           => 'submit',
	);

  return ($form);
}

/**
 * Validate form
 *
 * @ingroup form
 */
function _thtt_transfer_admin_price_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['fare_price'])) {
		form_set_error('fare_price', t('Field must be Numeric'));
	}
	
	$result = db_select('thtt_m_transfer_fare','t')
	->fields('t')
	->condition('t.fare_from',$form_state['values']['fare_from'])
	->condition('t.fare_to',$form_state['values']['fare_to'])
	->condition('t.fare_type',$form_state['values']['fare_type'])
	->execute();
	foreach($result as $itemTmp) {
		form_set_error('fare_from', t('From and To already existed in the system. Please change From, To or Tramsfer type'));
	}
	
}

/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _thtt_transfer_admin_price_add_form_submit($form, &$form_state) {
	$nid = db_insert('thtt_m_transfer_fare') // Table name no longer needs {}
	->fields(array(
			'fare_from' => $form_state['values']['fare_from'],
			'fare_to' => $form_state['values']['fare_to'],
			'fare_type' => $form_state['values']['fare_type'],
			'fare_price' => $form_state['values']['fare_price'],
			'fare_recommend' => $form_state['values']['fare_recommend'],
			'fare_rt_recommend' => $form_state['values']['fare_rt_recommend'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
  	// Print a 'OK' message
  	drupal_set_message(t('Data saved'));
  	$form_state['redirect'] = 'admin/config/content/thtt_transfer/price/';
}

/**
 * Module edit tour package page. Users can edit tour as requested.
 *
 * @ingroup form
 */
function _thtt_transfer_admin_price_edit_form($form, $form_state, $fare_id) {
	
	$query = db_select('thtt_m_transfer_fare','t');
	$query->fields('t');
	$query->condition('t.fare_id',$fare_id);
	$result = $query->execute();
	
	foreach($result as $item) {
		// Build the form
		
		//Init dropdown list
		$destinationOption = array();
		$result = db_select('thtt_m_transfer_destination','a')
		->fields('a')
		->execute();
		foreach($result as $itemTmp) {
			$destinationOption[$itemTmp->dest_id] = t($itemTmp->dest_name);
		}
		
		$typeOption = array();
		$result = db_select('thtt_m_transfer_type','a')
		->fields('a')
		->execute();
		foreach($result as $itemTmp) {
			$typeOption[$itemTmp->type_id] = t($itemTmp->type_name);
		}
		
		$form['fare_id'] = array(
				'#type' => 'hidden',
				'#value' => $fare_id,
		);
				
		// Build the form
		$form['fare_from'] = array(
				'#default_value'  => $item->fare_from,
				'#description'    => t('Transfer from'),
				'#title'          => t('Transfer from'),
				'#type'           => 'select',
				'#options'        => $destinationOption,
				'#required' => TRUE,
		);
		$form['fare_to'] = array(
				'#default_value'  => $item->fare_to,
				'#description'    => t('Transfer to'),
				'#title'          => t('Transfer to'),
				'#type'           => 'select',
				'#options'        => $destinationOption,
				'#required' => TRUE,
		);
		$form['fare_type'] = array(
				'#default_value'  => $item->fare_type,
				'#description'    => t('Transfer type'),
				'#title'          => t('Transfer type'),
				'#type'           => 'select',
				'#options'        => $typeOption,
				'#required' => TRUE,
		);
		$form['fare_price'] = array(
				'#default_value'  => $item->fare_price,
				'#description'    => t('Price of transfer'),
				'#title'          => t('Price of transfer'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		
		// Submit button
		$form['submit'] = array(
				'#value'          => t('  Save  '),
				'#type'           => 'submit',
		);
	}
  return ($form);
}


function _thtt_transfer_admin_price_edit_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['fare_price'])) {
		form_set_error('fare_price', t('Field must be Numeric'));
	}

	$result = db_select('thtt_m_transfer_fare','t')
	->fields('t')
	->condition('t.fare_from',$form_state['values']['fare_from'])
	->condition('t.fare_to',$form_state['values']['fare_to'])
	->condition('t.fare_type',$form_state['values']['fare_type'])
	->execute();
	foreach($result as $item) {
		if($item->fare_id != $form_state['values']['fare_id'] ){
			form_set_error('fare_from', t('From and To already existed in the system. Please change From, To or Tramsfer type'));
		}
	}

}
/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _thtt_transfer_admin_price_edit_form_submit($form, &$form_state) {
	$nid = db_update('thtt_m_transfer_fare') // Table name no longer needs {}
	->fields(array(
			'fare_from' => $form_state['values']['fare_from'],
			'fare_to' => $form_state['values']['fare_to'],
			'fare_type' => $form_state['values']['fare_type'],
			'fare_price' => $form_state['values']['fare_price'],
			'fare_recommend' => $form_state['values']['fare_recommend'],
			'fare_rt_recommend' => $form_state['values']['fare_rt_recommend'],
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	)) 
	->condition('fare_id', $form_state['values']['fare_id'])
	->execute();
	
	// Print a 'OK' message
	drupal_set_message(t('Data saved'));
	$form_state['redirect'] = 'admin/config/content/thtt_transfer/price/';
}


/**
 * Form builder for a tour delete
 */
function _thtt_transfer_admin_price_delete_form($form, $form_state, $fare_id) {
	$form = array();

	$form['_fare_id'] = array(
			'#type' => 'value',
			'#value' => $fare_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete price id : <strong>%fare_id</strong>?', array(
							'%$fare_id' => urldecode($fare_id)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _thtt_transfer_admin_price_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_transfer_fare')
		->condition('fare_id', $v['_fare_id'])
		->execute();
		drupal_set_message(t('The price was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/thtt_transfer/price/';
}

/**
 * Module Transfer type
 */
function _thtt_transfer_admin_type_add_form() {
		
	// Build the form
	$form['type_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer type name.'),
			'#title'          => t('Transfer type name.'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	$form['type_desc'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer type description'),
			'#title'          => t('Transfer type description'),
			'#type'           => 'textarea',
    		'#required' => FALSE,
	);
	$form['type_pax'] = array(
			'#default_value'  => '',
			'#description'    => t('per type'),
			'#title'          => t('Number of pax'),
			'#type'           => 'textfield',
			'#required' => FALSE,
	);
	$form['type_max_pax'] = array(
			'#default_value'  => '1',
			'#description'    => t('per type'),
			'#title'          => t('Max number of pax'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	$form['type_max_vehicle'] = array(
			'#default_value'  => '1',
			'#description'    => t('per type of company stock'),
			'#title'          => t('Max number of vehicle'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	$form['type_img'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Type image'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['display_order'] = array(
			'#default_value'  => '1',
			'#description'    => t('Sorting for displaying'),
			'#title'          => t('Display order'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('  Save  '),
			'#type'           => 'submit',
	);

	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _thtt_transfer_admin_type_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['type_max_pax'])) {
		form_set_error('type_max_pax', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['type_max_vehicle'])) {
		form_set_error('type_max_vehicle', t('Field must be Numeric'));
	}
}

/**
 * Module add category page submit. 
 */
function _thtt_transfer_admin_type_add_form_submit($form, &$form_state) {
	
	if($form_state['values']['type_img'] != 0){
		$file = file_load($form_state['values']['type_img']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'thtt_transfer', 'image', $form_state['values']['type_img']);
	}
	
	$nid = db_insert('thtt_m_transfer_type') // Table name no longer needs {}
	->fields(array(
			'type_name' => $form_state['values']['type_name'],
			'type_desc' => $form_state['values']['type_desc'],
			'type_pax' => $form_state['values']['type_pax'],
			'type_max_pax' => $form_state['values']['type_max_pax'],
			'type_max_vehicle' => $form_state['values']['type_max_vehicle'],
			'type_img' => $form_state['values']['type_img'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Transfer type saved'));
	 
	$form_state['redirect'] = 'admin/config/content/thtt_transfer/type/';
	 
}

/**
 * Module Tour Category edit page.
 */
function _thtt_transfer_admin_type_edit_form($form, $form_state, $type_id) {
	$result = db_select('thtt_m_transfer_type','t')
			->fields('t')
			->condition('t.type_id',$type_id)
			->execute();
	
	foreach($result as $item) {
		// Build the form
		$form['type_id'] = array(
				'#type' => 'hidden',
				'#value' => $type_id,
			);
		$form['type_name'] = array(
				'#default_value'  => $item->type_name,
				'#description'    => t('Transfer type name.'),
				'#title'          => t('Transfer type name.'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['type_desc'] = array(
				'#default_value'  => $item->type_desc,
				'#description'    => t('Transfer type description'),
				'#title'          => t('Transfer type description'),
				'#type'           => 'textarea',
	    		'#required' => FALSE,
		);
		$form['type_pax'] = array(
				'#default_value'  => $item->type_pax,
				'#description'    => t('per type'),
				'#title'          => t('Number of pax'),
				'#type'           => 'textfield',
				'#required' => FALSE,
		);
		$form['type_max_pax'] = array(
				'#default_value'  => $item->type_max_pax,
				'#description'    => t('per type'),
				'#title'          => t('Max number of pax'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['type_max_vehicle'] = array(
				'#default_value'  => $item->type_max_vehicle,
				'#description'    => t('per type of company stock'),
				'#title'          => t('Max number of vehicle'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['type_img_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->type_img,
			);
		$form['type_img'] = array(
				'#default_value'  => $item->type_img,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Type image'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying'),
				'#title'          => t('Display order'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		
		// Submit button
		$form['submit'] = array(
				'#value'          => t('  Save  '),
				'#type'           => 'submit',
		);
	}
	
	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _thtt_transfer_admin_type_edit_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['type_max_pax'])) {
		form_set_error('type_max_pax', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['type_max_vehicle'])) {
		form_set_error('type_max_vehicle', t('Field must be Numeric'));
	}
}

/**
 * Module add category page submit.
 */
function _thtt_transfer_admin_type_edit_form_submit($form, &$form_state) {
	
	if($form_state['values']['type_img)old'] != $form_state['values']['type_img'] && $form_state['values']['type_img'] != 0){
		$file = file_load($form_state['values']['type_img']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'thtt_transfer', 'image', $form_state['values']['type_img']);
	}
	
	$nid = db_update('thtt_m_transfer_type') // Table name no longer needs {}
	->fields(array(
			'type_name' => $form_state['values']['type_name'],
			'type_desc' => $form_state['values']['type_desc'],
			'type_pax' => $form_state['values']['type_pax'],
			'type_max_pax' => $form_state['values']['type_max_pax'],
			'type_max_vehicle' => $form_state['values']['type_max_vehicle'],
			'type_img' => $form_state['values']['type_img'],
			'display_order' => $form_state['values']['display_order'],
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->condition('type_id', $form_state['values']['type_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Data saved'));

	$form_state['redirect'] = 'admin/config/content/thtt_transfer/type';
}


/**
 * Form builder for a tour delete
 */
function _thtt_transfer_admin_type_delete_form($form, $form_state, $type_id, $type_name) {
	$form = array();

	$form['type_id'] = array(
			'#type' => 'value',
			'#value' => $type_id
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete Transfer Type : <strong>%name</strong>?', array(
							'%name' => urldecode($type_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _thtt_transfer_admin_type_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_transfer_type')
		->condition('type_id', $v['type_id'])
		->execute();
		drupal_set_message(t('Data was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/thtt_transfer/type';
}


/**
 * Module Tour Category settings page.
 */
function _thtt_transfer_admin_destination_add_form() {

	// Build the form
	$form['dest_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Transfer destination name.'),
			'#title'          => t('Transfer destination name.'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	$form['display_order'] = array(
			'#default_value'  => '1',
			'#description'    => t('Sorting for displaying'),
			'#title'          => t('Display order'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);

	// Submit button
	$form['submit'] = array(
			'#value'          => t('  Save  '),
			'#type'           => 'submit',
	);

	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _thtt_transfer_admin_destination_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
}

/**
 * Module add category page submit.
 */
function _thtt_transfer_admin_destination_add_form_submit($form, &$form_state) {

	$nid = db_insert('thtt_m_transfer_destination') // Table name no longer needs {}
	->fields(array(
			'dest_name' => $form_state['values']['dest_name'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();

	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Data saved'));

	$form_state['redirect'] = 'admin/config/content/thtt_transfer/destination/';

}

/**
 * Module Tour Category edit page.
 */
function _thtt_transfer_admin_destination_edit_form($form, $form_state, $dest_id) {
	$result = db_select('thtt_m_transfer_destination','t')
	->fields('t')
	->condition('t.dest_id',$dest_id)
	->execute();

	foreach($result as $item) {
		// Build the form
		$form['dest_id'] = array(
				'#type' => 'hidden',
				'#value' => $dest_id,
		);
		$form['dest_name'] = array(
				'#default_value'  => $item->dest_name,
				'#description'    => t('Transfer destination name.'),
				'#title'          => t('Transfer destination name.'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying'),
				'#title'          => t('Display order'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);

		// Submit button
		$form['submit'] = array(
				'#value'          => t('  Save  '),
				'#type'           => 'submit',
		);
	}

	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _thtt_transfer_admin_destination_edit_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
}

/**
 * Module add category page submit.
 */
function _thtt_transfer_admin_destination_edit_form_submit($form, &$form_state) {

	$nid = db_update('thtt_m_transfer_destination') // Table name no longer needs {}
	->fields(array(
			'dest_name' => $form_state['values']['dest_name'],
			'display_order' => $form_state['values']['display_order'],
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->condition('dest_id', $form_state['values']['dest_id'])
	->execute();

	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Data saved'));

	$form_state['redirect'] = 'admin/config/content/thtt_transfer/destination';
}


/**
 * Form builder for a tour delete
 */
function _thtt_transfer_admin_destination_delete_form($form, $form_state, $dest_id, $dest_name) {
	$form = array();

	$form['dest_id'] = array(
			'#type' => 'value',
			'#value' => $dest_id
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete Transfer destination : <strong>%name</strong>?', array(
							'%name' => urldecode($dest_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _thtt_transfer_admin_destination_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_transfer_destination')
		->condition('dest_id', $v['dest_id'])
		->execute();
		drupal_set_message(t('Data was deleted.'));
	}

	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/thtt_transfer/destination';
}