<?php

/**
 * The main user hook to display a slideshow.
 *
 * @param $output
 *   String. All the page text with the slideshow code
 * @return
 *   String. All the page text with the slideshow HTML/Javascript
 */
function _package_tour_process_text($output) {
	//more
	if (preg_match_all(
			'/\[more]/i', $output, $matches, PREG_SET_ORDER
	)) {
		$o = explode ('[more]' , $output);
		$output = $o[0]."<p><a href='javascript:;' id='show' onclick=\"showmore('overview');\" class=\"showmore\">Show More</a></p>";
		$output .= "<div id=\"overview\" style=\"display:none;\">".$o[1]."<p><a href=\"javascript:;\" id=\"show\" class=\"showmore\" onclick=\"showless('overview');\">Show Less</a></div></p>";
	}
  
  // Return the original text with all slideshows correctly
  // inserted
  return $output;
}


function split_on($string, $num) {
	$length = strlen($string);
	$output[0] = substr($string, 0, $num);
	$output[1] = substr($string, $num, $length );
	return $output;
}


/**
 * Module Tour settings page.
 */
function _package_tour_list_item($argument1) {
	
	$titlePage = "";
	$contentHTML = "";
	
	$query = db_select('url_alias','t');
	$query->fields('t')
	->condition('t.alias',$argument1);
	$result = $query->execute();
	
	foreach($result as $item) {
		$sourceArr = explode("/", $item->source);
		$nid = $sourceArr[1];
			
		$query2 = db_select('thtt_m_tour','t');
		$query2->join('thtt_m_tour_category', 'c', 't.tour_category_id = c.tour_category_id');
		$query2->fields('t')
		->condition('t.nid',$nid)
		->condition('t.is_enable','Y')
		->range(0, 1);
		$result2 = $query2->execute();
		
		$tourItem = null;
		foreach($result2 as $item2) {
			$tourItem = $item2;
			$titlePage = $tourItem->tour_name;
			
			// load node
			$nodeLoad = node_load($tourItem->nid);
		}
	}

	$contentHTML .= '<div class="col-md-12 col-sm-12"><a href="">Home</a> > <a href="/package-tours"> Tour Packages</a> > <b>'.$tourItem->tour_name.'</b> </div>';
	//$contentHTML .= '<div style="margin-top: 50px;"></div>';
	$contentHTML .= '<div class="container">';
	$contentHTML .= '<article id="main" class="col-md-10 col-sm-12">';
	$contentHTML .= '<div style="margin-top:20px;">';
	$contentHTML .= $tourItem->tour_short_desc;
	$contentHTML .= '</div>';
	$contentHTML .= '<center>';
	
	try{
		if($tourItem->tour_picture_path != 0 && $tourItem->tour_picture_path != ""){
			$img = file_create_url(file_load($tourItem->tour_picture_path)->uri);
		}else{
			$img = "";
		}
	}catch (Exception $e) {
		$img = "";
	}
	
	if($img != ""){
		$variables = array(
				'path' => $img,
				'alt' => '',
				'title' => '',
				'width' => '100%',
				'height' => '',
				'attributes' => array('class' => 'tour-img-item')
		);
		$contentHTML .= theme('image', $variables);
	}else{
		$contentHTML .= "<div class='home-item-no-photo'></div>";
	}
	
	
	$contentHTML .= '<div class="col-md-12 booking-panel">';
	
	$query = db_select('thtt_m_program','t');
	$query->fields('t')
	->condition('t.tour_id', $tourItem->tour_id);
	
	$result = $query->execute();
	$tourItem = null;
	
	foreach($result as $item) {
		$contentHTML .= '<div class="col-md-12 booking-panel-item">';
		$contentHTML .= '<div class="col-md-5 col-sm-12" style="color:#0072A7;font-size:14px;font-weight:bold;">'. $item->prog_name .'</div>';
		$contentHTML .= '<div class="col-md-5 col-sm-12" >';
		$contentHTML .= '<div class="col-md-12 price" style="text-decoration:line-through; color:#333; font-weight:normal;">Adult: THB '. number_format($item->price_adult,0) .' / Child: THB '. number_format($item->price_child,0) .'</div>';
		$contentHTML .= '<div class="col-md-12"  style="color:red;font-size:14px;font-weight:bold;">Adult: THB '. number_format($item->price_new_adult,0) .' / Child: THB '. number_format($item->price_new_child,0) .'</div>';
		$contentHTML .= '</div>';
		$contentHTML .= '<div class="col-md-2 col-sm-12"><a class="btn btn-booking" href="javascript:;" onclick="makebooking('. $item->prog_id .');">Make Booking!</a></div>';
		$contentHTML .= '</div>';
	}
	
	$contentHTML .= '</div>';
	$contentHTML .= '</center>';
	$contentHTML .= '<div id="bodycontent" class="col-md-12 my-container">';
	$contentHTML .= '<style scoped>@import "sites/all/modules/ckeditor/content.css"; </style>';
	$contentHTML .= render($nodeLoad->body['und'][0]['value']);
	
	//********* Comments ****************
	$contentHTML .= "<HR/>";
	$contentHTML .= "<h2 style='margin-top:50px; position:relative;'> Reviews </h2>";
	
	$queryComment = db_select('node','n');
	$queryComment->join('comment', 'c', 'n.nid=c.nid');
	$queryComment->join('field_data_comment_body', 'b', 'b.entity_id=c.cid');
	$queryComment->fields('c')
							->fields('b')
	->condition('n.nid',$nid);
	$resultComment = $queryComment->execute();
	
	foreach($resultComment as $itemComment) {
		$contentHTML .= "<div class='col-md-12 col-sm-12' style='border:1px dashed #646464; position:relative; padding: 20px;'>";
		$contentHTML .= "<h3 style='color:#003663;'>{$itemComment->subject}</h3>";

		$contentHTML .= "<div class='col-md-12 col-sm-12' style='font-size:14px; color:#AAA;'><b>name :</b> {$itemComment->name} <b>Created :</b> {$itemComment->created}</div>";
		
		$contentHTML .= "<div style='position:relative;'>{$itemComment->comment_body_value}</div>";
		$contentHTML .= "</div>";

		$contentHTML .= "<HR/>";
	}
	

	$contentHTML .= "<HR style='margin-top:20px; position:relative;'/>";

	$contentHTML .= "<div class='col-md-12 col-sm-12' style='background-color:#eee; margin-top:30px; padding-top:10px;'>";
	$contentHTML .= "<h4>Add your review</h4>";
	$contentHTML .= drupal_render(drupal_get_form("comment_node_{$nodeLoad->type}_form", (object) array('nid' => $nodeLoad->nid)));
	
	$contentHTML .= "</div>";
	
	
	$contentHTML .= "<HR/>";
	
	$contentHTML .= '</div>';
	$contentHTML .= '</article>';
	

// 	//<!-- ****************	License ****************** -->
// 	$contentHTML .= '<div class="ads-content col-md-2 col-sm-12">';
// 	$contentHTML .= '<ul>';
// 	$contentHTML .= '<li>';
// 	$variables = array(
// 			'path' => 'images/best_price.png',
// 			'alt' => 'Best price',
// 			'title' => 'Best price',
// 			'width' => '',
// 			'height' => '',
// 	);
// 	$contentHTML .= theme('image', $variables);
// 	$contentHTML .= '</li>';
// 	$contentHTML .= '<li>';
// 	$variables = array(
// 			'path' => 'images/ttt.png',
// 			'alt' => '',
// 			'title' => '',
// 			'width' => '',
// 			'height' => '',
// 	);
// 	$contentHTML .= theme('image', $variables);
// 	$contentHTML .= '<BR /> <BR /> TAT Licence 31 / 00904</li>';
// 	$contentHTML .= '</ul>';
// 	$contentHTML .= '</div>';

	$contentHTML .= '</div>';
	$contentHTML .= '<div class="dash-line"></div>';
	$contentHTML .= '<script>';
	$contentHTML .= 'function makebooking(id){';
	$contentHTML .= '	window.location.href = "'.$GLOBALS['base_url'].'/booking?p="+id;';
	$contentHTML .= '}';
	$contentHTML .= '</script>';
	
	drupal_set_title($titlePage);
	
	$page_keywords = array(
			'#type' => 'html_tag',
			'#tag' => 'meta',
			'#attributes' => array(
					'name' => 'keywords',
					'content' => $titlePage,
			)
	);
	drupal_add_html_head($page_keywords, 'page_keywords');
	
	
  return $contentHTML;
}
