<?php
/**
 * @author Bruno Massa http://drupal.org/user/67164
 * @file
 * Create true slideshows using any image over internet with many other features.
 */


/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_submit(&$from, &$form_state) {
  $settings = $form_state['values'];
  unset($settings['submit']);
  unset($settings['form_id']);
  unset($settings['form_build_id']);
  unset($settings['form_token']);
  unset($settings['op']);

  // Add a '#' in all field names
  foreach ($settings as $index => $value) {
    $settings["#$index"] = $value;
    unset($settings[$index]);
  }

  // Save the data into database
  variable_set('package_tour_settings', $settings);

  // Print a 'OK' message
  drupal_set_message(t('Settings saved'));
}



/**
 * Module Tour settings page. 
 */
function _package_tour_admin_add_form() {
	// Get the default settings for all slideshows
	$settings = variable_get('package_tour_settings', array());

	// Build the form
// 	$form['tour_cd'] = array(
// 			'#default_value'  => empty($settings['#tour_cd']) ? '' : $settings['#tour_cd'],
// 			'#description'    => t('Tour code for refer in content.'),
// 			'#title'          => t('Tour CD'),
// 			'#type'           => 'textfield',
//     		'#required' => TRUE,
// 	);
	$result = db_select('thtt_m_tour_category','a')
  	->fields('a', array('tour_category_id','tour_category_name'))
	->execute();
	 
	$categoryOption = array();
	 
	foreach($result as $item) {
		$categoryOption[$item->tour_category_id] = t($item->tour_category_name);
	}
	
	
	$form['tour_category_id'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour category'),
			'#title'          => t('Tour Category'),
			'#type'           => 'select',
			'#options'        => $categoryOption,
    		'#required' => TRUE,
	);

	$displayOrder = array();
	for($n=1; $n<=20; $n++){
		$displayOrder[$n] = $n;
	}
	$form['display_order'] = array(
			'#default_value'  => $item->display_order,
			'#description'    => t('Sorting for displaying on packaging tour.'),
			'#title'          => t('Display order'),
			'#type'           => 'select',
			'#options'        => $displayOrder,
			'#required' => TRUE,
	);
	$form['tour_picture_cover_path'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture cover'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['tour_picture_path'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
// 	$form['nid'] = array(
// 			'#default_value'  => '',
// 			'#description'    => t('Link page'),
// 			'#title'          => t('Link page'),
// 			'#type'           => 'select',
// 			'#options'        => $nodeOption,
//     		'#required' => TRUE,
// 	);
	$form['tour_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour name (limit 255 Character)'),
			'#title'          => t('Tour name'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
			'#attributes' => array('onKeyPress' => "return(this.value.length<255)"),
	);
	$form['tour_short_desc'] = array(
			'#default_value'  => '',
			'#description'    => t('Short description, limit 500 character.'),
			'#title'          => t('Tour short description'),
			'#type' => 'textarea',
			'#required' => TRUE,
			'#attributes' => array('onKeyPress' => "return(this.value.length<500)"),
	);
// 	$form['tour_desc'] = array(
// 			'#default_value'  => '',
// 			'#description'    => t('Full description'),
// 			'#title'          => t('Full description'),
// 			'#type' => 'text_format',
// 			'#format' => 'full_html',
//     		'#required' => TRUE,
// 	);

	$form['tour_content'] = array(
			'#default_value'  => '',
			'#description'    => t('Full content description'),
			'#title'          => t('Full content description'),
			'#type' => 'text_format',
			'#format' => 'full_html',
    		'#required' => TRUE,
			'#rows' => '18'
	);
	
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('Save tour'),
			'#type'           => 'submit',
	);

  return ($form);
}

function ajax_example_autocheckboxes_callback($form, $form_state) {
	return $form['checkboxes_fieldset'];
}
/**
 * Validate form
 *
 * @ingroup form
 */
function _package_tour_admin_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
// 	if (!is_numeric($form_state['values']['price_adult'])) {
// 		form_set_error('price_adult', t('Field must be Numeric'));
// 	}
// 	if (!is_numeric($form_state['values']['price_child'])) {
// 		form_set_error('price_child', t('Field must be Numeric'));
// 	}
// 	if (!is_numeric($form_state['values']['price_new_adult'])) {
// 		form_set_error('price_new_adult', t('Field must be Numeric'));
// 	}
// 	if (!is_numeric($form_state['values']['price_new_child'])) {
// 		form_set_error('price_new_child', t('Field must be Numeric'));
// 	}
}

/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_add_form_submit($form, &$form_state) {
	
	
	if(!isset($form_state['values']['tour_picture_path']) || $form_state['values']['tour_picture_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_path']);
	}
	
	if(!isset($form_state['values']['tour_picture_cover_path']) || $form_state['values']['tour_picture_cover_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_cover_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_cover_path']);
	}
	
	/*
	 * *********** Add new Node **************
	 */
	global $user;

	/*
	 * Set URL Alias name
	 */
	$aliasURL = str_replace(' ', '-', $form_state['values']['tour_name']);
	$aliasURL = str_replace('_', '-', $aliasURL);
	$aliasURL = preg_replace('/[^A-Za-z0-9\-]/', '', $aliasURL); // Removes special chars.
	
	$node = new stdClass();
	$node->title = $form_state['values']['tour_name'];
	$node->type = "tour_content";
	node_object_prepare($node); // Sets some defaults. Invokes hook_prepare() and hook_node_prepare().
	$node->language = LANGUAGE_NONE; // Or e.g. 'en' if locale is enabled
	$node->uid = $user->uid;
	$node->status = 1; //(1 or 0): published or not
	$node->promote = 0; //(1 or 0): promoted to front page
	$node->comment = 1; // 0 = comments disabled, 1 = read only, 2 = read/write
	$node->body[$node->language][0]['value'] = $form_state['values']['tour_content']['value'];
	$node->body[$node->language][0]['summary'] = '';
	$node->body[$node->language][0]['format'] = $form_state['values']['tour_content']['format'];
	$node->path['alias'] = $aliasURL;

	if ($node = node_submit($node)) {
		node_save($node);
	}
	//drupal_set_message( "Node with nid " . $node->nid . " saved!\n");
	
	
	/*
	 * *********** Add new tour **************
	 */
	$tour_id = db_insert('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'tour_desc' => $form_state['values']['tour_desc'],
			'nid' => $node->nid,
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'tour_picture_cover_path' => $form_state['values']['tour_picture_cover_path'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	
  	// Print a 'OK' message
  	drupal_set_message(t('Tour saved'));
  	
  	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
  	
}

/**
 * Module edit tour package page. Users can edit tour as requested.
 *
 * @ingroup form
 */
function _package_tour_admin_edit_form($form, $form_state, $tour_id) {
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$result = $query
	->fields('t')
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();
	
	foreach($result as $item) {
		// Build the form
		
		$form['tour_id'] = array(
				'#type' => 'hidden',
				'#value' => $tour_id,
		);
		
		//---------- Get Category list ---------
		$result = db_select('thtt_m_tour_category','a')
	  	->fields('a', array('tour_category_id','tour_category_name'))
		->execute();
		
		$categoryOption = array();
		
		foreach($result as $item2) {
			$categoryOption[$item2->tour_category_id] = t($item2->tour_category_name);
		}
		
		$form['tour_category_id'] = array(
				'#default_value'  => $item->tour_category_id,
				'#description'    => t('Tour category'),
				'#title'          => t('Tour Category'),
				'#type'           => 'select',
				'#options'        => $categoryOption,
				'#required' => TRUE,
		);

		$displayOrder = array();
		for($n=1; $n<=20; $n++){
			$displayOrder[$n] = $n;
		}
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying on packaging tour.'),
				'#title'          => t('Display order'),
				'#type'           => 'select',
				'#options'        => $displayOrder,
	    		'#required' => TRUE,
		);
		$form['tour_picture_cover_path'] = array(
				'#default_value'  => $item->tour_picture_cover_path,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture cover'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
				'#upload_validators' => array(
						'file_validate_extensions' => array("png jpg jpeg gif"),
				),
		);
		$form['tour_picture_path'] = array(
				'#default_value'  => $item->tour_picture_path,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
				'#upload_validators' => array(
						'file_validate_extensions' => array("png jpg jpeg gif"),
				),
		);
		$form['tour_name'] = array(
				'#default_value'  => $item->tour_name,
				'#description'    => t('Tour name (Limit 255 Character)'),
				'#title'          => t('Tour name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
				'#attributes' => array('onKeyPress' => "return(this.value.length<255)"),
		);
		$form['tour_short_desc'] = array(
				'#default_value'  => $item->tour_short_desc,
				'#description'    => t('Short description, limit 500 character.'),
				'#title'          => t('Tour short description'),
				'#type' => 'textarea',
				'#required' => TRUE,
				'#attributes' => array('onKeyPress' => "return(this.value.length<500)"),
		);
		

// 		$form['nid'] = array(
// 				'#default_value'  => $item->nid,
// 				'#description'    => t('Link page'),
// 				'#title'          => t('Link page'),
// 				'#type'           => 'select',
// 				'#options'        => $nodeOption,
// 				'#required' => TRUE,
// 		);


		$form['nid'] = array(
				'#type' => 'hidden',
				'#value' => $item->nid,
		);
		
		// load node
		$nodeLoad = node_load($item->nid);

		$form['tour_content'] = array(
				'#default_value'  => $nodeLoad->body['und'][0]['value'],
				'#description'    => t('Full content description'),
				'#title'          => t('Full content description'),
				'#type' => 'text_format',
				'#format' => 'full_html',
				'#required' => TRUE,
				'#rows' => '18'
		);
		
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save'),
				'#type'           => 'submit',
		);
	}
  return ($form);
}


/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_edit_form_submit($form, &$form_state) {
	
	if(!isset($form_state['values']['tour_picture_path']) || $form_state['values']['tour_picture_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_path']);
	}
	
	if(!isset($form_state['values']['tour_picture_cover_path']) || $form_state['values']['tour_picture_cover_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_cover_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_cover_path']);
	}

	/*
	 * *********** Update new Node **************
	 */
	global $user;
	
	/*
	 * Set URL Alias name
	 */
	$aliasURL = str_replace(' ', '-', $form_state['values']['tour_name']);
	$aliasURL = str_replace('_', '-', $aliasURL);
	$aliasURL = preg_replace('/[^A-Za-z0-9\-]/', '', $aliasURL); // Removes special chars.
	
	$node = new stdClass();
	$node->nid = $form_state['values']['nid'];
	$node->title = $form_state['values']['tour_name'];
	$node->type = "tour_content";
	node_object_prepare($node); // Sets some defaults. Invokes hook_prepare() and hook_node_prepare().
	$node->language = LANGUAGE_NONE; // Or e.g. 'en' if locale is enabled
	$node->uid = $user->uid;
	$node->status = 1; //(1 or 0): published or not
	$node->promote = 0; //(1 or 0): promoted to front page
	$node->comment = 1; // 0 = comments disabled, 1 = read only, 2 = read/write
	$node->body[$node->language][0]['value'] = $form_state['values']['tour_content']['value'];
	$node->body[$node->language][0]['summary'] = '';
	$node->body[$node->language][0]['format'] = $form_state['values']['tour_content']['format'];
	$node->path['alias'] = $aliasURL;
	
	if ($node = node_submit($node)) {
		node_save($node);
	}
	//drupal_set_message( "Node with nid " . $node->nid . " saved!\n");
	
	/*
	 * ***** Update Tour *****
	 */
	$nid = db_update('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'tour_desc' => $form_state['values']['tour_desc'],
			'nid' => $form_state['values']['nid'],
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'tour_picture_cover_path' => $form_state['values']['tour_picture_cover_path'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $user->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $user->name,
			'update_date' => date("Y-m-d H:i:s", time())
	)) 
	->condition('tour_id', $form_state['values']['tour_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
	 
}


/**
 * Form builder for a tour delete
 */
function _package_tour_admin_delete_form($form, $form_state, $tour_id, $tour_name) {
	$form = array();

	$form['_tour_id'] = array(
			'#type' => 'value',
			'#value' => $tour_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete tour <strong>%profile</strong>?', array(
							'%profile' => urldecode($tour_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _package_tour_admin_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_tour')
		->condition('tour_id', $v['_tour_id'])
		->execute();
		
		drupal_set_message(t('The tour was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/package_tour/tour';
}

/**
 * Module Tour Category settings page.
 */
function _package_tour_admin_category_add_form() {
	
	$result = db_select('thtt_m_group','a')
	->fields('a', array('group_id','group_name'))
	->execute();
	
	$groupOption = array();
	
	foreach($result as $item) {
		$groupOption[$item->group_id] = t($item->group_name);
	}
	
	// Build the form
	$form['group_id'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour Group'),
			'#title'          => t('Tour Group'),
			'#type'           => 'select',
			'#options'        => $groupOption,
			'#required' => TRUE,
	);

	$form['tour_category_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour category name.'),
			'#title'          => t('Tour category name'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	
	$form['display_order'] = array(
			'#default_value'  => '',
			'#description'    => t('Sorting for displaying on packaging tour.'),
			'#title'          => t('Display order'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	
	$form['slideshow_flg'] = array(
			'#default_value'  => 'Y',
			'#description'    => t('Check for using in slideshow.'),
			'#title'          => t('Slideshow'),
			'#type'           => 'checkbox',
	);

	$form['photo1'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 1'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	/*
	$form['photo2'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 2'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo3'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 3'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo4'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 4'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo5'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 5'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	*/
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('Save category'),
			'#type'           => 'submit',
	);

	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _package_tour_admin_category_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	
	if($form_state['values']['slideshow_flg']==1){
		if($form_state['values']['photo1']==0 
			&& $form_state['values']['photo2']==0
			&& $form_state['values']['photo2']==0 
			&& $form_state['values']['photo2']==0 
			&& $form_state['values']['photo2']==0  ){
				form_set_error('photo1', t('If you need to slideshow, please add photo at least 1 photo for sliding show.'));
		}
	}
}

/**
 * Module add category page submit. 
 */
function _package_tour_admin_category_add_form_submit($form, &$form_state) {
	$slideshowFlg = 'N';
	if($form_state['values']['slideshow_flg'] != ""){
		$slideshowFlg = "Y";
	}
	
	if($form_state['values']['photo1'] != 0){
		$file = file_load($form_state['values']['photo1']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo1']);
	}
	if($form_state['values']['photo2'] != 0){
		$file = file_load($form_state['values']['photo2']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo2']);
	}
	if($form_state['values']['photo3'] != 0){
		$file = file_load($form_state['values']['photo3']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo3']);
	}
	if($form_state['values']['photo4'] != 0){
		$file = file_load($form_state['values']['photo4']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo4']);
	}
	if($form_state['values']['photo5'] != 0){
		$file = file_load($form_state['values']['photo5']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo5']);
	}
	
	$nid = db_insert('thtt_m_tour_category') // Table name no longer needs {}
	->fields(array(
			'group_id' => $form_state['values']['group_id'],
			'tour_category_name' => $form_state['values']['tour_category_name'],
			'slideshow_flg' => $slideshowFlg,
			'display_order' => $form_state['values']['display_order'],
			'photo1' => $form_state['values']['photo1'],
			'photo2' => $form_state['values']['photo2'],
			'photo3' => $form_state['values']['photo3'],
			'photo4' => $form_state['values']['photo4'],
			'photo5' => $form_state['values']['photo5'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour Category saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/category';
	 
}

/**
 * Module Tour Category edit page.
 */
function _package_tour_admin_category_edit_form($form, $form_state, $tour_category_id) {
	$result = db_select('thtt_m_tour_category','t')
			->fields('t')
			->condition('t.tour_category_id',$tour_category_id)
			->execute();
	
	foreach($result as $item) {
		// Build the form
		$form['tour_category_id'] = array(
				'#type' => 'hidden',
				'#value' => $tour_category_id,
		);


		$result2 = db_select('thtt_m_group','a')
		->fields('a', array('group_id','group_name'))
		->execute();
		
		$groupOption = array();
		
		foreach($result2 as $item2) {
			$groupOption[$item2->group_id] = t($item2->group_name);
		}
		
		// Build the form
		$form['group_id'] = array(
				'#default_value'  => $item->tour_group_id,
				'#description'    => t('Tour Group'),
				'#title'          => t('Tour Group'),
				'#type'           => 'select',
				'#options'        => $groupOption,
				'#required' => TRUE,
		);
		
		$form['tour_category_name'] = array(
				'#default_value'  => $item->tour_category_name,
				'#description'    => t('Tour category name.'),
				'#title'          => t('Tour category name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
	
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying on packaging tour.'),
				'#title'          => t('Display order'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
	
		if($item->slideshow_flg == "Y" ){
			$defaultSlideshow = 1;
		}else{
			$defaultSlideshow = 0;
		}
		
		$form['slideshow_flg'] = array(
				'#default_value'  => $defaultSlideshow,
				'#description'    => t('Check for using in slideshow.'),
				'#title'          => t('Slideshow'),
				'#type'           => 'checkbox',
		);
		
		$form['photo1_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo1,
		);
		/*
		$form['photo2_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo2,
		);
		
		$form['photo3_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo3,
		);
		
		$form['photo4_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo4,
		);
		
		$form['photo5_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo5,
		);
		*/
		$form['photo1'] = array(
				'#default_value'  => $item->photo1,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 1'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		/*
		$form['photo2'] = array(
				'#default_value'  => $item->photo2,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 2'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo3'] = array(
				'#default_value'  => $item->photo3,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 3'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo4'] = array(
				'#default_value'  => $item->photo4,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 4'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo5'] = array(
				'#default_value'  => $item->photo5,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 5'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
	*/
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save category'),
				'#type'           => 'submit',
		);
	}
	
	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _package_tour_admin_category_edit_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	
	if($form_state['values']['slideshow_flg']==1){
		if($form_state['values']['photo1']==0
				&& $form_state['values']['photo2']==0
				&& $form_state['values']['photo3']==0
				&& $form_state['values']['photo4']==0
				&& $form_state['values']['photo5']==0  ){
			form_set_error('photo1', t('If you need to slideshow, please add photo at least 1 photo for sliding show.'));
		}
	}
	
}

/**
 * Module add category page submit.
 */
function _package_tour_admin_category_edit_form_submit($form, &$form_state) {
	
	$slideshowFlg = 'N';
	if($form_state['values']['slideshow_flg'] != ""){
		$slideshowFlg = "Y";
	}
	if($form_state['values']['photo1_old'] != $form_state['values']['photo1'] && $form_state['values']['photo1'] != 0){
		$file = file_load($form_state['values']['photo1']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo1']);
	}
	if($form_state['values']['photo2_old'] != $form_state['values']['photo2'] && $form_state['values']['photo2'] != 0){
		$file = file_load($form_state['values']['photo2']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo2']);
	}
	if($form_state['values']['photo3_old'] != $form_state['values']['photo3'] && $form_state['values']['photo3'] != 0){
		$file = file_load($form_state['values']['photo3']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo3']);
	}
	if($form_state['values']['photo4_old'] != $form_state['values']['photo4'] && $form_state['values']['photo4'] != 0){
		$file = file_load($form_state['values']['photo4']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo4']);
	}
	if($form_state['values']['photo5_old'] != $form_state['values']['photo5'] && $form_state['values']['photo5'] != 0){
		$file = file_load($form_state['values']['photo5']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo5']);
	}
	
	$nid = db_update('thtt_m_tour_category') // Table name no longer needs {}
	->fields(array(
			'group_id' => $form_state['values']['group_id'],
			'tour_category_name' => $form_state['values']['tour_category_name'],
			'slideshow_flg' => $slideshowFlg,
			'display_order' => $form_state['values']['display_order'],
			'photo1' => $form_state['values']['photo1'],
			'photo2' => $form_state['values']['photo2'],
			'photo3' => $form_state['values']['photo3'],
			'photo4' => $form_state['values']['photo4'],
			'photo5' => $form_state['values']['photo5'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->condition('tour_category_id', $form_state['values']['tour_category_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour Category saved'));

	$form_state['redirect'] = 'admin/config/content/package_tour/category';
}


/**
 * Form builder for a tour delete
 */
function _package_tour_admin_category_delete_form($form, $form_state, $category_id, $category_name) {
	$form = array();

	$form['tour_category_id'] = array(
			'#type' => 'value',
			'#value' => $category_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete tour category <strong>%name</strong>?', array(
							'%name' => urldecode($category_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _package_tour_admin_category_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_tour_category')
		->condition('tour_category_id', $v['tour_category_id'])
		->execute();
		drupal_set_message(t('The tour category was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/package_tour/category';
}


/*
 * ************************ Program Tour **************************
 */
function _package_tour_admin_program_list($form, $form_state, $tour_id) {

	/*
	 * ******* List of programs tour ************
	 */
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$query->leftJoin('thtt_m_program', 'p', 'p.tour_id = t.tour_id');
	$result = $query
	->fields('p')
	->fields('t', array('tour_name','tour_picture_cover_path'))
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();

	$tourName = "";
	$imgId = "";
	$options = array();
	foreach ($result as $itemNode) {
		$tourName = $itemNode->tour_name;
		$imgId = $itemNode->tour_picture_cover_path;
		
		if($itemNode->prog_id != ""){
			$options[$itemNode->prog_id] = array(
					'display_order' => $itemNode->display_order,
					'prog_name' => $itemNode->prog_name,
					'price_adult' => $itemNode->price_adult,
					'price_child' => $itemNode->price_child,
					'price_new_adult' => $itemNode->price_new_adult,
					'price_new_child' => $itemNode->price_new_child,
					'operation' => l("Edit", 'admin/config/content/package_tour/tour/program/edit/' . $itemNode->prog_id )
			);
		}
	}
	
	$form['tour']['#markup'] = "<h3><b>Tour name : </b> $tourName </h3><BR/>";

	$form['tour_id'] = array(
			'#type' => 'hidden',
			'#value' => $tour_id,
	);
	
	try{
		if($imgId != 0 && $imgId != ""){
			$img = file_create_url(file_load($imgId)->uri);
			$variables = array(
					'path' => $img,
					'alt' => '',
					'title' => '',
					'width' => '200px',
					'height' => '',
					'attributes' => array('class' => 'tour-img-item')
			);
			$form['tour_img']['#markup'] = theme('image', $variables)."<BR/><HR/><BR/>";
		}else{
			$img = "";
		}
	}catch (Exception $e) {
	}
	
	$form['_tour_id'] = array(
			'#type' => 'value',
			'#value' => $tour_id,
	);

	$form['add']['#markup'] = l('<input type="button" value="Add new program price" class="form-submit"/>', 'admin/config/content/package_tour/tour/program/' . urlencode($tour_id) .'/add', array('html' => TRUE, ));

	// del button
	$form['del_submit'] = array(
			'#value'          => t('Delete'),
			'#type'           => 'submit',
			'#attributes' => array('onClick' => "return confirm('Are you sure for delete items?')"),
	);
	
	
	$header = array(
			'prog_name' => t('Program name'),
			'display_order' => t('Display order'),
			'price_adult' => t('Price old adult'),
			'price_child' => t('price old child'),
			'price_new_adult' => t('Price new adult'),
			'price_new_child' => t('price new child'),
			'operation' => t('Operation'),
	);

	$form['table'] = array(
			'#type' => 'tableselect',
			'#header' => $header,
			'#options' => $options,
			'#empty' => t('Not found'),
			'#description'    => t('List of programs'),
			'#title'          => t('Programs'),
	);

	return ($form);
}

function _package_tour_admin_program_list_submit($form, &$form_state) {
	foreach ($form_state['values']['table'] as $val){
		$v = & $form_state['values'];

		db_delete('thtt_m_program')
		->condition('prog_id', $val)
		->execute();
	}
	
	drupal_set_message(t('Tour program was deleted'));
 	$form_state['redirect'] = 'admin/config/content/package_tour/tour/program/'.$form_state['values']['tour_id'];
}

function _package_tour_admin_program_form($form, $form_state, $tour_id) {
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$result = $query
	->fields('t', array('tour_name'))
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();

	foreach($result as $item) {
		$form['tour']['#markup'] = "<b>Tour name : </b> $item->tour_name";
	}
	
	$form['tour_id'] = array(
			'#type' => 'hidden',
			'#value' => $tour_id,
	);

	$displayOrder = array();
	for($n=1; $n<=20; $n++){
		$displayOrder[$n] = $n;
	}
	$form['display_order'] = array(
			'#default_value'  => 1,
			'#description'    => t('Sorting for displaying'),
			'#title'          => t('Display order'),
			'#type'           => 'select',
			'#options'        => $displayOrder,
			'#required' => TRUE,
	);
	$form['prog_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Program name (Limit 255 Character)'),
			'#title'          => t('Program name'),
			'#type'           => 'textfield',
			'#required' => TRUE,
			'#attributes' => array('onKeyPress' => "return(this.value.length<255)", 'style' => 'width:100%; line-height: 20px;' ),
	);
	$form['price_adult'] = array(
			'#default_value'  => '',
			'#description'    => t('THB (Numeric only)'),
			'#title'          => t('Adult price (Normal price)'),
			'#type'           => 'textfield',
			'#required' => TRUE,
			'#attributes' => array('style' => 'line-height: 20px;' ),
	);
	$form['price_child'] = array(
			'#default_value'  => '',
			'#description'    => t('THB (Numeric only)'),
			'#title'          => t('Child price (Normal price)'),
			'#type'           => 'textfield',
			'#required' => TRUE,
			'#attributes' => array('style' => 'line-height: 20px;' ),
	);
	$form['price_new_adult'] = array(
			'#default_value'  => '',
			'#description'    => t('THB (Numeric only)'),
			'#title'          => t('Adult price (New price)'),
			'#type'           => 'textfield',
			'#attributes' => array('style' => 'line-height: 20px;' ),
	);
	$form['price_new_child'] = array(
			'#default_value'  => '',
			'#description'    => t('THB (Numeric only)'),
			'#title'          => t('Child price (New price)'),
			'#type'           => 'textfield',
			'#attributes' => array('style' => 'line-height: 20px;' ),
	);

	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('Save'),
			'#type'           => 'submit',
	);

	return ($form);
}

function _package_tour_admin_program_form_validate($form, &$form_state) {
	if ($form_state['values']['price_adult'] !="" && !is_numeric($form_state['values']['price_adult'])) {
		form_set_error('price_adult', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_child'] !="" && !is_numeric($form_state['values']['price_child'])) {
		form_set_error('price_child', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_new_adult'] !="" && !is_numeric($form_state['values']['price_new_adult'])) {
		form_set_error('price_new_adult', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_new_child'] !="" && !is_numeric($form_state['values']['price_new_child'])) {
		form_set_error('price_new_child', t('Field must be Numeric'));
	}
}


function _package_tour_admin_program_form_submit($form, &$form_state) {

	$priceAdultNew = $form_state['values']['price_adult'];
	$priceChildNew = $form_state['values']['price_child'];
	
	if($form_state['values']['price_new_adult']!=""){
		$priceAdultNew = $form_state['values']['price_new_adult'];
	}
	if($form_state['values']['price_new_child']!=""){
		$priceChildNew = $form_state['values']['price_new_child'];
	}
	
	$nid = db_insert('thtt_m_program') // Table name no longer needs {}
	->fields(array(
			'prog_name' => $form_state['values']['prog_name'],
			'tour_id' => $form_state['values']['tour_id'],
			'display_order' => $form_state['values']['display_order'],
			'price_adult' => $form_state['values']['price_adult'],
			'price_child' => $form_state['values']['price_child'],
			'price_new_adult' => $priceAdultNew,
			'price_new_child' => $priceChildNew,
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	drupal_set_message(t('Tour program saved'));

	$form_state['redirect'] = 'admin/config/content/package_tour/tour/program/'.$form_state['values']['tour_id'];
}



function _package_tour_admin_program_edit_form($form, $form_state, $prog_id) {
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$query->join('thtt_m_program', 'p', 't.tour_id = p.tour_id');
	$result = $query
	->fields('p')
	->fields('t', array('tour_name'))
	->fields('u', array('tour_category_name'))
	->condition('p.prog_id',$prog_id)
	->execute();

	foreach($result as $item) {
		$form['tour']['#markup'] = "<b>Tour name : </b> $item->tour_name";

		$form['prog_id'] = array(
				'#type' => 'hidden',
				'#value' => $prog_id,
		);

		$form['tour_id'] = array(
				'#type' => 'hidden',
				'#value' => $item->tour_id,
		);
	
		$displayOrder = array();
		for($n=1; $n<=20; $n++){
			$displayOrder[$n] = $n;
		}
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying'),
				'#title'          => t('Display order'),
				'#type'           => 'select',
				'#options'        => $displayOrder,
				'#required' => TRUE,
		);
		$form['prog_name'] = array(
				'#default_value'  => $item->prog_name,
				'#description'    => t('Program name (Limit 255 Character)'),
				'#title'          => t('Program name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
				'#attributes' => array('onKeyPress' => "return(this.value.length<255)", 'style' => 'width:100%; line-height: 20px;' ),
		);
		$form['price_adult'] = array(
				'#default_value'  => $item->price_adult,
				'#description'    => t('THB (Numeric only)'),
				'#title'          => t('Adult price (Normal price)'),
				'#type'           => 'textfield',
				'#required' => TRUE,
				'#attributes' => array('style' => 'line-height: 20px;' ),
		);
		$form['price_child'] = array(
				'#default_value'  => $item->price_child,
				'#description'    => t('THB (Numeric only)'),
				'#title'          => t('Child price (Normal price)'),
				'#type'           => 'textfield',
				'#required' => TRUE,
				'#attributes' => array('style' => 'line-height: 20px;' ),
		);
		$form['price_new_adult'] = array(
				'#default_value'  => $item->price_new_adult,
				'#description'    => t('THB (Numeric only)'),
				'#title'          => t('Adult price (New price)'),
				'#type'           => 'textfield',
				'#attributes' => array('style' => 'line-height: 20px;' ),
		);
		$form['price_new_child'] = array(
				'#default_value'  => $item->price_new_child,
				'#description'    => t('THB (Numeric only)'),
				'#title'          => t('Child price (New price)'),
				'#type'           => 'textfield',
				'#attributes' => array('style' => 'line-height: 20px;' ),
		);
	
	
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save'),
				'#type'           => 'submit',
		);

		$form['cancel']['#markup'] = l('<input type="button" value="Cancel" class="form-submit"/>', 'admin/config/content/package_tour/tour/program/' . urlencode($item->tour_id), array('html' => TRUE, ));
		
	}
	
	return ($form);
}

function _package_tour_admin_program_edit_form_validate($form, &$form_state) {
	if ($form_state['values']['price_adult'] !="" && !is_numeric($form_state['values']['price_adult'])) {
		form_set_error('price_adult', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_child'] !="" && !is_numeric($form_state['values']['price_child'])) {
		form_set_error('price_child', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_new_adult'] !="" && !is_numeric($form_state['values']['price_new_adult'])) {
		form_set_error('price_new_adult', t('Field must be Numeric'));
	}
	if ($form_state['values']['price_new_child'] !="" && !is_numeric($form_state['values']['price_new_child'])) {
		form_set_error('price_new_child', t('Field must be Numeric'));
	}
}


function _package_tour_admin_program_edit_form_submit($form, &$form_state) {

	$priceAdultNew = $form_state['values']['price_adult'];
	$priceChildNew = $form_state['values']['price_child'];

	if($form_state['values']['price_new_adult']!=""){
		$priceAdultNew = $form_state['values']['price_new_adult'];
	}
	if($form_state['values']['price_new_child']!=""){
		$priceChildNew = $form_state['values']['price_new_child'];
	}

	$nid = db_update('thtt_m_program') // Table name no longer needs {}
	->fields(array(
			'prog_name' => $form_state['values']['prog_name'],
// 			'tour_id' => $form_state['values']['tour_id'],
			'display_order' => $form_state['values']['display_order'],
			'price_adult' => $form_state['values']['price_adult'],
			'price_child' => $form_state['values']['price_child'],
			'price_new_adult' => $priceAdultNew,
			'price_new_child' => $priceChildNew,
// 			'create_by' => $GLOBALS['user']->name,
// 			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->condition('prog_id',$form_state['values']['prog_id'])
	->execute();

	//drupal_flush_all_caches();
	drupal_set_message(t('Tour program saved'));

	$form_state['redirect'] = 'admin/config/content/package_tour/tour/program/'.$form_state['values']['tour_id'];
}


/*
 * ************************************** Transaction ***************************************************
 */


function package_tour_admin_transaction($ghi = 0, $jkl = '') {
	$output = "";
	$ref_code = "";

	if(isset($_GET['ref_code'])){
		$ref_code = $_GET['ref_code'];
	}

	$query = db_select('thtt_t_reservation','t');
	$query->leftJoin('thtt_t_reservation_detail', 'd', 't.rsvn_id = d.rsvn_id');
	$query->fields('t')
	->fields('d');
	//->fields('ty', array('type_name'));
	//$query->addField('d1', 'dest_name', 'dest_from_name');
	//$query->addField('d2', 'dest_name', 'dest_to_name');

	if($ref_code != ""){
		$query->condition('t.rsvn_ref', '%' . db_like($ref_code) . '%', 'LIKE');
	}

	$query->orderBy('t.rsvn_ref', 'DESC');
	$result = $query->execute();

	$output .= '<h4>'.t('Search').'</h4>';
	$output .= '<form>';
	$output .= t('Ref code').' : '.' <input type="text" name="ref_code" value="'.$ref_code.'" style="border: solid 1px #000000; line-height: 20px;"/> <input type="submit" name="search" vale="'.t('Search').'" style="width:80px; height:28px; border: solid 1px #000000; "/>';
	$output .= '</form>';
	$output .= '<BR/><BR/>';


	$header = array(t('Operations'), t('Ref code'), t('Customer name'), t('Customer contact')
			, t('Tour information'), t('Number of Adult'), t('Total price (THB)')
			, t('Status'), t('Create date'));
		
	foreach($result as $item) {
		 
		$status = "";
		if($item->rsvn_status == 1){
			$status = "Unpaid";
		}else if($item->rsvn_status == 2){
			$status = "Paid";
		}

		$rows[] = array(
				array(
						'data' =>
						l('<input type="button" value="Close job" class="form-submit"/>',  'admin/config/content/package_tour/transaction/finish/' . urlencode($item->rsvn_id), array('html'=> TRUE)) 
						." <BR/>". l('<input type="button" value="View detail" class="form-submit"/>', 'admin/config/content/package_tour/transaction/detail/' . urlencode($item->rsvn_id), array('html'=>TRUE)) ,
						'valign' => 'top'
				),
				array('data' => $item->rsvn_ref, 'valign' => 'top'),
				array('data' => "$item->rsvn_guest_title.$item->rsvn_guest_fname $item->rsvn_guest_lname <BR/>($item->rsvn_nationality) <BR/> (<b>IP:</b> $item->rsvn_ip)" , 'valign' => 'top'),
				array('data' => "<b>Tel :</b> $item->rsvn_tel <BR/> <b>email:</b> $item->rsvn_email", 'valign' => 'top'),
				 
				array('data' => "<b>Tour name:</b> $item->tour_name <BR/>  <b>Program:</b> $item->prog_name <BR/> <b>Travel Date:</b> $item->rsvn_travel_date", 'valign' => 'top'),
				array('data' => '<b>Adult:</b> '.$item->rsvn_adult.' <BR/> <b>Child:</b> '.$item->rsvn_child.'<BR/> <b>Infant:</b> '.$item->rsvn_infant, 'valign' => 'top'),
				array('data' => $item->rsvn_price_total." ".$item->currency_cd, 'valign' => 'top'),
				 
				array('data' => t($status), 'valign' => 'top'),
				array('data' => $item->create_date, 'valign' => 'top'),
		);
	}

	$output .= theme('table', array("header" => $header, "rows" => $rows));
	return $output;
}


function package_tour_admin_transaction_detail($ref_code){

	$output = "";
	
	$query = db_select('thtt_t_reservation','t');
	$query->leftJoin('thtt_t_reservation_detail', 'd', 't.rsvn_id = d.rsvn_id');
	$query->fields('t')
	->fields('d');
	//->fields('ty', array('type_name'));
	//$query->addField('d1', 'dest_name', 'dest_from_name');
	//$query->addField('d2', 'dest_name', 'dest_to_name');
	
	if($ref_code != ""){
		$query->condition('t.rsvn_id', $ref_code);
	}
	
	$query->orderBy('t.rsvn_ref', 'DESC');
	$result = $query->execute();
	
	$header = array(t(' '), t(' '));

	$options= array();
	$options['attributes']['target'] = '_blank';
	$options['html'] = TRUE;
	
	$output .= l('<input type="button" value="Export PDF" class="form-submit"/>', "admin/config/content/package_tour/transaction/detail/$ref_code/pdf", $options );

	foreach($result as $item) {
			
		$status = "";
		if($item->rsvn_status == 1){
			$status = "Unpaid";
		}else if($item->rsvn_status == 2){
			$status = "Paid";
		}
	
		$rows[] = array(
				array('data' => t('Ref code'), 'valign' => 'top'),
				array('data' => $item->rsvn_ref, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('IP Address'), 'valign' => 'top'),
				array('data' => $item->rsvn_ip, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Customer name'), 'valign' => 'top'),
				array('data' => $item->rsvn_guest_title.$item->rsvn_guest_fname.' '.$item->rsvn_guest_lname, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Nationality'), 'valign' => 'top'),
				array('data' => $item->rsvn_nationality, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Tel'), 'valign' => 'top'),
				array('data' => $item->rsvn_tel, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Email'), 'valign' => 'top'),
				array('data' => $item->rsvn_email, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Travel Date'), 'valign' => 'top'),
				array('data' => $item->rsvn_travel_date, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Tour name'), 'valign' => 'top'),
				array('data' => $item->tour_name, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Program'), 'valign' => 'top'),
				array('data' => $item->prog_name, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Number of Adult'), 'valign' => 'top'),
				array('data' => 'Adult: '.$item->rsvn_adult.', Child: '.$item->rsvn_child.', Infant: '.$item->rsvn_infant, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Total price'), 'valign' => 'top'),
				array('data' => $item->rsvn_price_total." ".$item->currency_cd, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Booking No'), 'valign' => 'top'),
				array('data' => $item->rsvn_booking_no, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Pickup - Dropoff'), 'valign' => 'top'),
				array('data' => 'Pickup: '.$item->rsvn_pickup.' Dropoff: '.$item->rsvn_dropoff, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Hotel'), 'valign' => 'top'),
				array('data' => $item->rsvn_hotel.", room: ".$item->rsvn_rooms, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Checkin - Checkout'), 'valign' => 'top'),
				array('data' => "Check-in: ".$item->rsvn_checkin." Check-out: ".$item->rsvn_checkout, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Arrival flight'), 'valign' => 'top'),
				array('data' => $item->rsvn_arr_flight." (Date: ".$item->rsvn_arr_date." ".$item->rsvn_arr_time.")", 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Depart flight'), 'valign' => 'top'),
				array('data' => $item->rsvn_dep_flight." (Date: ".$item->rsvn_depart_date." ".$item->rsvn_dep_time.")", 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Ref code'), 'valign' => 'top'),
				array('data' => $item->rsvn_special_request, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Status'), 'valign' => 'top'),
				array('data' => t($status), 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Create date'), 'valign' => 'top'),
				array('data' => $item->create_date, 'valign' => 'top')
		);
	}
	
	$output .= theme('table', array("header" => $header, "rows" => $rows));
	
	return $output;
}


function package_tour_admin_transaction_detail_pdf ( $ref_code) {

	$output =	package_tour_admin_transaction_detail($ref_code);
	
	$fb_lib_path = function_exists('libraries_get_path') ? libraries_get_path('tcpdf') : 'sites/all/libraries/tcpdf';
	$fb_platform = $fb_lib_path . '/tcpdf.php';
	try {
		if (!class_exists('TCPDF') && !@include($fb_platform)) {
			//show error
			return NULL;
		}

		define('K_TCPDF_EXTERNAL_CONFIG', true);
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		//$pdf->SetHeaderData(PDF_HEADER_IMAGE, PDF_HEADER_IMAGE_WIDTH);
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM+20);
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);


		$pdf->SetPrintHeader(false);
		$pdf->SetPrintFooter(false);

		// set some language-dependent strings (optional)
		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
			require_once(dirname(__FILE__).'/lang/eng.php');
			$pdf->setLanguageArray($l);
		}

		// 	 		$logo=base_url('assets/images/logo.jpg');

		// add a page
		$pdf->AddPage();
		$pdf->SetFont( 'angsanaupc' , '', 14, '', true);
			
		$pdf->writeHTML($output, true, false, false, false, '');


		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		$pdf->Output('custinvoice_finance.pdf', 'I');
			

	}
	catch (Exception $e) {}

	//return $output;
}

