<?php

function _exchange_get_price_rate($type, $booth_cd, $curr_from, $curr_to, $amount){
	
		$query = db_select('thtt_exchange_m_currency_branch','t');
		$result = $query
		->fields('t')
		->condition('t.currency_id',$curr_from)
		->condition('t.booth_cd',$booth_cd)
		->range(0,1)
		->orderBy("create_dttm","DESC")
		->execute();
		
		$curr1 = 1;
		foreach($result as $item) {
			if($type == "SELLING"){
				$curr1 = $item->rate_sell;
			}else{
				$curr1 = $item->rate_buy;
			}
		}
		
		$query2 = db_select('thtt_exchange_m_currency_branch','t');
		$result2 = $query2
		->fields('t')
		->condition('t.currency_id',$curr_to)
		->condition('t.booth_cd',$booth_cd)
		->orderBy("create_dttm","DESC")
		->range(0,1)
		->execute();
		
		$curr2 = 1;
		foreach($result2 as $item) {
			if($type == "SELLING"){
				$curr2 = $item->rate_sell;
			}else{
				$curr2 = $item->rate_buy;
			}
		}
		
		if($type == "SELLING"){
			$rate = $curr2;
		}else{
			$rate = $curr1;
		}
		
		$conRate = $curr1/$curr2;
		$total = $amount * $conRate;
		
		$output = "{
		\"rate\": $rate,
		\"total\": $total,
		\"curr1\": $curr1,
		\"curr2\": $curr2
		}";
		return $output;

}





function generateDocNo($increase=FALSE, $booth_cd){
	$strDocNo = "";
	$doc_no = 'EX'.$booth_cd;
	$doc_pattern_id = 2;
	$y = date("Y")-2000;
	$m = date("m");

	$query = db_select('thtt_m_doc_running_no','a');
	$query->join("thtt_m_doc_pattern", "b", "b.doc_pattern_id = a.doc_pattern_id ");
	$result = $query
	->fields('a')
	->condition('a.doc_no',$doc_no)
	->condition('a.doc_pattern_id',$doc_pattern_id)
	->execute();

	$num_of_results = $result->rowCount();
	if($num_of_results==0){
		$rsvn_id = db_insert('thtt_m_doc_running_no')
		->fields(array(
				'doc_current_no' => 0,
				'doc_pattern_id' => $doc_pattern_id,
				'doc_no' => $doc_no
		))
		->execute();
	}

	$query2 = db_select('thtt_m_doc_running_no','a');
	$query2->join("thtt_m_doc_pattern", "b", "b.doc_pattern_id = a.doc_pattern_id ");
	$result2 = $query2
	->fields('a')
	->fields('b')
	->condition('a.doc_no',$doc_no)
	->condition('a.doc_pattern_id',$doc_pattern_id)
	->execute();

	foreach($result2 as $item2) {
		$num = $item2->doc_current_no + 1;

		$format = $item2->doc_pattern;
		$format = str_replace("{b}",$booth_cd,$format);
		$format = str_replace("{y}",$y,$format);
		$format = str_replace("{m}",$m,$format);
		$strDocNo =  sprintf($format, $num);

		if($increase){
			$rsvn_id = db_update('thtt_m_doc_running_no')
			->fields(array(
					'doc_current_no' => $num
			))
			->condition('doc_pattern_id', $doc_pattern_id)
			->condition('doc_no', $doc_no)
			->execute();
		}
	}

	return $strDocNo;
}



function _exchange_get_trns_detail($trns_id){
	$query = db_select('thtt_exchange_t_transaction_detail','t')
	->condition('t.trns_master_id', $trns_id)
	->fields('t');
	$result = $query->execute();

	$detail = "[";
	$chk = false;
	foreach($result as $item) {
		if($chk){
			$detail .= ",";
		}else{
			$chk = true;
		}

		$detail .= " {\"currency\" : \"$item->currency_name\" , \"price_rate\" : $item->unit_price , \"amount\" : \"".number_format($item->amount,2)."\" , \"total\" : \"".number_format($item->total,2)."\"} ";
	}

	$detail .= "]";

	$output = "{\"master_id\" : $trns_id , \"detail\" : $detail  }";
	echo $output;
}
