<?php

/**************************************************************************************
 *       							Accounting first page
 **************************************************************************************/
function _exchange_thaihappy_acc() {
	$output = "";

	// ---- Start HTML output -----
	$output .= '<div class="col-md-12 col-sm-12">
					<h3>Exchange Menu for Accounting</h3>
				</div>';

	$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';

	$output .= l('<input type="button" value="Chart Summary" class="btn btn-exchange col-md-6 col-sm-12"/>', 'exchange_thaihappy/acc/chart_today', array(
			'html' => TRUE
	));
	$output .= l('<input type="button" value="Search Transactions" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/acc/transactions', array(
			'html' => TRUE
	));
	$output .= l('<input type="button" value="Summary Report Today (All branch)" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/acc/report_today', array(
			'html' => TRUE
	));
	$output .= l('<input type="button" value="Logout" class="btn btn-exchange  col-md-6 col-sm-12"/>', 'user/logout', array(
			'html' => TRUE
	));

	return $output;
}

function _exchange_thaihappy_acc_transactions() {
	global $user;
	global $base_url;
	$output = "";

	// ******* Start HTML *********

	// --------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="' . $base_url . '/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';

	// --------- Booth Options -----------
	$query = db_select('thtt_exchange_m_booth', 'b');
	$query->join('thtt_exchange_m_user_tenant', 'ut', 'ut.tenant_cd = b.tenant_cd');
	$result = $query->fields('b')->condition('ut.uid', $user->uid)->execute();

	$boothOption = '<select id="booth_cd"  name="booth_cd" class="form-control" style="width:90%;">';
	$boothOption .= '<option value="" selected="selected">---- All ----</option>';
	foreach ($result as $item) {
		$boothOption .= '<option value="' . $item->booth_cd . '">' . $item->booth_name . '</option>';
	}
	$boothOption .= '</select>';

	// --------- Javascript ----------
	$ajaxCalRowTotalUrl = $base_url . "/exchange_thaihappy/ajax_trns_search";
	$ajaxCalCancelTrans = $base_url . "/exchange_thaihappy/ajax_cancel_trns_approve";
	$ajaxShowDetailUrl = $base_url . "/exchange_thaihappy/ajax_trns_detail";
	$ajaxShowReasonUrl = $base_url . "/exchange_thaihappy/ajax_view_reason";
	$output .= '
	<script type="text/javascript">
	$(document).ready(function(){
			
		var dateToday = new Date();
        $("#inDate").val(dateToday.getFullYear()+"-"+ (dateToday.getMonth() + 1)+"-"+ dateToday.getDate());


		var dates = $("#inDate, #outDate").datepicker({
		changeMonth: true,
		numberOfMonths: 1,
		// 		      minDate: dateToday,
		dateFormat: \'yy-mm-dd\',
		onSelect: function(selectedDate) {
			var option = this.id == "inDate" ? "minDate" : "maxDate",
				instance = $(this).data("datepicker"),
				date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
				dates.not(this).datepicker("option", option, date);
			}
		});
		 
		
	//************ Search *************
	$("#search").click(function(){
	event.preventDefault();
	
	var trns_no = $("#trns_no").val();
	var trns_date_from = $("#inDate").val();
	var trns_date_to = $("#outDate").val();
	var booth_cd = $("#booth_cd").val();
	
	var postParam = { "trns_no" : trns_no, "trns_date_from" :trns_date_from, "trns_date_to" :  trns_date_to , "booth_cd" : booth_cd};
	var url = "' . $ajaxCalRowTotalUrl . '";
	var jqxhr = $.post( url, postParam, function(data) {
	$("table tbody").html("");
	data.results.forEach(function(entry) {
	var markup = "";
		
	if(entry.flag_cancel == "R"){
		markup += "<tr class=\"flag-cancel\">";
	}else{
		markup += "<tr>";
	}
		
	markup += "		<td>";
	if(entry.flag_cancel == "R"){
		markup += "				<input type=\'button\' class=\"btn btn-default req_cancel\" value=\'Approve Cancel\' onClick=\"cancelClick("+entry.trns_master_id+")\">";
		markup += "				<input type=\'button\' class=\"btn btn-default cancel_reason\" value=\'View Cancel Reason\' onClick=\"viewReason("+entry.trns_master_id+")\">";
	}
	markup += "				<input type=\'button\' class=\"btn btn-default view_detail\" value=\'Detail\' onClick=\"showDetail("+entry.trns_master_id+", \'"+entry.trns_no+"\', \'"+entry.total+"\' )\">";
	markup += "		</td>";
	markup += "		<td>" + entry.trns_dttm + "</td>";
	markup += "		<td>" + entry.trns_no + "</td>";
	markup += "		<td>" + entry.trns_type + "</td>";
	markup += "		<td>" + entry.booth_name + "</td>";
	markup += "		<td>" + entry.total + "</td>";
	markup += "		<td>" + entry.currency_name + "</td>";
	markup += "</tr>";
	$("table tbody").append(markup);
	});
		
		
	}, "json")
	.done(function() {
	})
	.fail(function() {
	console.log( "error" );
	alert("An error occurred, Pleae contact admin.");
	})
	.always(function(data) {
	});
	});
		
	
		$("#detailDialog").dialog({
				modal: true,
				resizable: false,
    			autoOpen: false,
    			width: "500px",
    			heigth: "450px",
    			dialogClass: "no-close success-dialog",
				buttons: [
					{
			            text: "OK",
			            "class": "btn btn-default",
			            click: function() {
							$(this).dialog("close");
			            }
			        }
			        
				]
			});
	
	});
	
		
	function viewReason(id){
		   $(document).ready(function(){
					var postParam = { "trns_id" : id };
					var url = "' . $ajaxShowReasonUrl . '";
					var jqxhr = $.post( url, postParam, function(data) {
					
						var markup = "<h4>"+data.reason+"</h4>";
		   				$("#detailDialog").html(markup);
		   				$("#detailDialog").dialog ("open");
					
					}, "json")
				  .done(function() {
				  })
				  .fail(function() {
				    console.log( "error" );
				   		alert("An error occurred, Pleae contact admin.");
				  })
				  .always(function(data) {
				  });
		  
		   	});		
	
	}
	
	
	
	function showDetail(id, trns_no, total){
		   $(document).ready(function(){
					var postParam = { "trns_id" : id };
					var url = "' . $ajaxShowDetailUrl . '";
					var jqxhr = $.post( url, postParam, function(data) {
					
						var markup = "<h3>"+trns_no+"</h3>";
						markup +="<table ><thead> <tr>";
						markup +="<th>Currency</th>";
						markup +="<th>Currency Rate</th>";
						markup +="<th>Amount</th>";
						markup +="<th>Total</th>";
						markup +=" </tr></thead><tbody> ";
        
						data.detail.forEach(function(entry) {
						
							markup += "<tr>";
							markup += "		<td>" + entry.currency + "</td>";
							markup += "		<td>" + entry.price_rate + "</td>";
							markup += "		<td>" + entry.amount + "</td>";
							markup += "		<td>" + entry.total + "</td>";
							markup += "</tr>";
						});
						
						markup += "</tbody></table>";
						markup += "<h4 style=\"text-align:right;\">"+total+"</h4>";
						
		   				$("#detailDialog").html(markup);
		   				$("#detailDialog").dialog ("open");
					
					}, "json")
				  .done(function() {
				  })
				  .fail(function() {
				    console.log( "error" );
				   		alert("An error occurred, Pleae contact admin.");
				  })
				  .always(function(data) {
				  });
		  
		   	});
	}
	
	
	//************ Cancel Transaction *************
	function cancelClick(id){
	
		if(confirm("Do you request to cancel this transaction?")){
			var postParam = { "cancel_trns_id" : id};
			var url = "' . $ajaxCalCancelTrans . '";
			var jqxhr = $.post( url, postParam, function(data) {
		
			})
			.done(function() {
			})
			.fail(function() {
			console.log( "error" );
			})
			.always(function(data) {
			$("#search").click();
			});
		}
	};
	
	
	</script>
	';

	// ------------ Content ----------------
	$output .= '<div class="col-md-12 col-sm-12">
	<h2>' . t("Search Transactions") . '
	</div>';

	$output .= '<div class="col-md-12 col-sm-12 form-label">
	Search Form
	</div>';

	$output .= '	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()">';
	$output .= '<div class="col-md-3 col-sm-12">
	<div class="col-md-12 col-sm-12 form-label">
	Transaction No:
	</div>
	<div class="col-md-12 col-sm-12 form-entry">
	<input type="text" id="trns_no" name="trns_no" value=""/>
	</div>
	</div>';

	$output .= '<div class="col-md-5 col-sm-12">
	<div class="col-md-12 col-sm-12 form-label">
	Transaction Date (From-To):
	</div>
	<div class="col-md-12 col-sm-12 form-entry">
	<input id="inDate" name="inDate" type="text"
	value="" readonly="readonly"
	style="width: 40%; cursor: pointer;"> - <input id="outDate"
	name="outDate" type="text" value=""
	readonly="readonly" style="width: 40%; cursor: pointer;">
		
	</div>
	</div>';

	$output .= '<div class="col-md-4 col-sm-12">
	<div class="col-md-12 col-sm-12 form-label">
	Booth:
	</div>
	<div class="col-md-12 col-sm-12 form-entry text-left">' . $boothOption . '
	</div>
	</div>';

	$output .= '<div class="col-md-4 col-sm-12">
	<div class="col-md-12 col-sm-12 form-label">
	&nbsp;
	</div>
	<div class="col-md-12 col-sm-12 form-entry text-left">
	<input id="search" name="search" type="button" class="btn btn-primary add-row" value=" Search ">
	<input type="reset" class="btn btn-default" value=" Clear Search ">
	</div>
	</div>';

	$output .= '</form>';
	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';

	// -------------- Search Results ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel">';
	$output .= '<div class="col-md-12 col-sm-12">
	Search Results
	</div>';

	$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000; width:90%"/>';
	$output .= '<div class="col-md-12 col-sm-12">
						<!--<input type="button" class="btn btn-default" value="Export to summary report" onClick="exportSummaryReport()"/>-->
					</div>';

	$output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
	<th>Operations</th>
	<th>Transaction Date</th>
	<th>Transaction No.</th>
	<th>Type</th>
	<th>Booth name</th>
	<th>Total</th>
	<th>Currency</th>
	</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
		
	<div id="loadingDiv" class="modal"><!-- Place at bottom of page --></div>
	';

	$output .= '</div>';

	$output .= '<div id="detailDialog" title="Transaction Description">
	<p></p>
	</div>';

	return $output;
}

function _exchange_thaihappy_acc_report_today() {
	global $user;
	global $base_url;
	$output = "";

	// ******* Start HTML *********

	// --------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="' . $base_url . '/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';

	// --------- Javascript ----------
	$ajaxCalRowTotalUrl = $base_url . "/admin/config/content/exchange_thaihappy/acc/report_today_excel";
	$ajaxCalRowTotalUrlAll = $base_url . "/admin/config/content/exchange_thaihappy/acc/report_today_excel_all";
	$output .= '
	<script type="text/javascript">
	$(document).ready(function(){
	  var dateToday = new Date();
      $("#inDate").val(dateToday.getFullYear()+"-"+ (dateToday.getMonth() + 1)+"-"+ dateToday.getDate());

		var dates = $("#inDate, #outDate").datepicker({
			changeMonth: true,
			numberOfMonths: 1,
			dateFormat: \'yy-mm-dd\',
			onSelect: function(selectedDate) {
				var option = this.id == "inDate" ? "minDate" : "maxDate",
				instance = $(this).data("datepicker"),
				date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
				dates.not(this).datepicker("option", option, date);
			}
		});
	});

	function init() {
	}

	function exportAllClick() {
		console.log("exportAll Click");
		var frm = document.getElementById("frm");
		frm.action = "' . $ajaxCalRowTotalUrlAll . '";
		console.log(frm.action);
		frm.submit();
	}
	</script>
	';

	// ------------ Content ----------------
	$output .= '<div class="col-md-12 col-sm-12">
	<h2>' . t("Summary Report (All Branch)") . '
	</div>';

	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';

	// -------------- Search Results ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel">';
	$output .= '<div class="col-md-12 col-sm-12">
	Search Form
	</div>';

	$output .= '	<form id="frm" method="POST" action="' . $ajaxCalRowTotalUrl . '" target="">';

	$output .= '<div class="col-md-6 col-sm-12 form-label">
	Transaction Date : <input id="inDate" name="inDate" type="text"
	value="" readonly="readonly"
	style="width: 40%; cursor: pointer;">
	</div>';

	$output .= '<div class="col-md-6 col-sm-12">
	<col-md-12 col-sm-12 form-entry text-left">
	<input type="reset" class="btn btn-default" value=" Clear Search ">
	<input id="search" name="search" type="submit" class="btn btn-primary add-row" value=" Export to Excel ">
	<input id="exportall" name="exportall" type="button" class="btn btn-primary add-row" onclick="exportAllClick()" value=" Export to Excel (Summary All)">
	</div>
	</div>';

	$output .= '</form>';
	$output .= "<iframe id='act' name='act' style='display:none'></iframe>";
	$output .= '</div>';

	return $output;
}

function _exchange_thaihappy_acc_report_today_excel_result() {
	global $user;
	global $_SESSION;

	$trns_date = $_POST['inDate'];

	$pdate = date('Y-m-d', strtotime('+1 day', strtotime($trns_date)));
	$date = new DateTime($pdate);
	$yyyy = $date->format('Y');
	$mm = $date->format('m');
	$dd = $date->format('d');
	$toDay = $yyyy . "-" . $mm . "-" . $dd;
	// echo ">> ". $trns_date;
	// exit(0);

	$fb_lib_path = function_exists('libraries_get_path') ? libraries_get_path('PHPExcel-1.8') : 'sites/all/libraries/PHPExcel-1.8';
	$fb_platform = $fb_lib_path . '/Classes/PHPExcel.php';

	try {

		$query2 = db_select('thtt_exchange_m_setting', 't');
		$query2->fields('t');
		$query2->condition('t.setting_key', "WORKING_CUT_OFF");
		$result2 = $query2->execute();

		$cutingTime = "03:00:00";
		foreach ($result2 as $item2) {
			$cutingTime = $item2->setting_value;
		}

		require_once $fb_platform;
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user->name)->setLastModifiedBy($user->name)->setTitle("Summary Exchange Report Today")->setSubject("Summary Exchange Report Today")->setDescription("Summary Exchange Report Today")->setKeywords("office 2007 openxml php")->setCategory("Summary Exchange Report");

		// Add some data
		$style = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				)
		);
		$style_left = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
				)
		);
		$style_right = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
				)
		);
		$style_border = array(
				'borders' => array(
						'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN
						)
				)
		);
		$style_border_solid = array(
				'font' => array(
						'bold' => true,
						'size' => 15
				)
		);

		$query = db_query("
                                    select * from thtt_exchange_m_booth b
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = b.tenant_cd
                                    where ut.uid = " . $user->uid . "
                                    order by b.tenant_cd, b.booth_name
                            		");

		$sheetIndex = -1;
		$firstRec = true;
		$buyTotal = 0;
		$sellTotal = 0;
		$lastIndex = 0;
		$rowIndex = 8;

		$result = $query->fetchAll();
		foreach ($result as $item) {

			$queryCut = db_select('thtt_exchange_m_booth', 't');
			$queryCut->fields('t');
			$queryCut->condition('t.booth_cd', $item->booth_cd);
			$resultCut = $queryCut->execute();

			foreach ($resultCut as $itemCut) {
				if ($itemCut->cutofftime != null && $itemCut->cutofftime != "")
					$cutingTime = $itemCut->cutofftime;
			}

			$query3 = db_query("
                                    select count(*) as count_trns from thtt_exchange_t_transaction_master m
                                    where m.booth_cd = '$item->booth_cd'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                            		");
			$result3 = $query3->fetchAll();
			// echo "<pre>";
			// print_r($query3);
			// echo "</pre>";
			$chkZero = false;
			foreach ($result3 as $item3) {
				if ($item3->count_trns == 0) {
					$chkZero = true;
				}
			}

			if ($chkZero) {
				continue;
			}

			$objPHPExcel->createSheet();

			// Start new sheet
			$buyTotal = 0;
			$sellTotal = 0;
			$boothCD = $item->booth_cd;
			$sheetIndex = $sheetIndex + 1;
			$rowIndex = 6;

			// SET AUTO width
			// foreach(range('A','D') as $columnID) {
			// $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
			// ->setAutoSize(true);
			// }

			// Set style
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A2:D7")->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("B8:D999")->applyFromArray($style_right);
			$objPHPExcel->getActiveSheet()->getStyle('A6:D999')->getNumberFormat()->setFormatCode('#,##0.00');

			// Head and merge cell
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A2:D2');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A2', 'สรุปยอดการรับซื้ออัตราแลกเปลี่ยนเงินตราต่างประเทศ')->setCellValue('A4', 'ยอดประจำวันที่')->setCellValue('B4', $trns_date)->setCellValue('A5', $item->booth_name);

			// Header table of buying
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'BUYING');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':C' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('C' . ($rowIndex + 1), 'เลท')->setCellValue('B' . $rowIndex, 'ยอดรับซื้อ')->setCellValue('B' . ($rowIndex + 1), 'รับซื้อ')->setCellValue('D' . $rowIndex, 'ยอดรวม');

			$rowIndex = $rowIndex + 2;

			$queryBuying = db_query("
                                    select m.trns_type, m.booth_cd, h.booth_name, d.currency_id, d.currency_name, d.unit_price 
                                    	, SUM(d.amount) as buy_amount, SUM(d.total) as buy_total 
                                      from thtt_exchange_t_transaction_master m 
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id 
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd

                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'BUYING' 
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime' 
                                    and ut.uid = $user->uid  
                                    and m.booth_cd = '$item->booth_cd'
                                    GROUP BY m.trns_type, m.booth_cd, h.booth_name, d.currency_id, d.currency_name, d.unit_price 
                                    ORDER BY m.booth_cd, d.currency_name
                        		");

			$resultBuying = $queryBuying->fetchAll();
			foreach ($resultBuying as $itemBuying) {
				$buyTotal += $itemBuying->buy_total;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemBuying->currency_name)->setCellValue('B' . $rowIndex, ($itemBuying->buy_amount))->setCellValue('C' . $rowIndex, $itemBuying->unit_price)->setCellValue('D' . $rowIndex, $itemBuying->buy_total);
				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดรับซื้อ')->setCellValue('D' . $rowIndex, $buyTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . ($hTableRow) . ":D" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":D" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Header table of Selling
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'SELLING');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $rowIndex . ":I" . ($rowIndex + 1))->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':C' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('C' . ($rowIndex + 1), 'เลท')->setCellValue('B' . $rowIndex, 'ยอดนำส่ง')->setCellValue('B' . ($rowIndex + 1), 'ขาย')->setCellValue('D' . $rowIndex, 'ยอดรวม');

			$rowIndex = $rowIndex + 2;

			$querySelling = db_query("
                                    select m.trns_type, m.booth_cd, h.booth_name, d.currency_id, d.currency_name, d.unit_price
                                    	, SUM(d.amount) as sell_amount, SUM(d.total) as sell_total
                                      from thtt_exchange_t_transaction_master m
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd
			    
                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'SELLING'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                                    and ut.uid = $user->uid
			                       and m.booth_cd = '$item->booth_cd'
                                    GROUP BY m.trns_type, m.booth_cd, h.booth_name, d.currency_id, d.currency_name, d.unit_price
                                    ORDER BY m.booth_cd, d.currency_name
                        		");

			$resultSelling = $querySelling->fetchAll();
			foreach ($resultSelling as $itemSelling) {
				$sellTotal += $itemSelling->sell_amount;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemSelling->currency_name)->setCellValue('B' . $rowIndex, ($itemSelling->sell_total))->setCellValue('C' . $rowIndex, $itemSelling->unit_price)->setCellValue('D' . $rowIndex, $itemSelling->sell_amount);

				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $hTableRow . ":D" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดขาย')->setCellValue('D' . $rowIndex, $sellTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":D" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Header table of Commission
			$comTotal = 0;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'Commission');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $rowIndex . ":E" . ($rowIndex + 1))->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':D' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E' . $rowIndex . ':E' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('B' . $rowIndex, 'Commission (Selling)')->setCellValue('B' . ($rowIndex + 1), 'ขาย')->setCellValue('C' . ($rowIndex + 1), 'เลจปกติ')->setCellValue('D' . ($rowIndex + 1), 'Discount rate')->setCellValue('E' . $rowIndex, 'ค่าคอมฯ');

			$rowIndex = $rowIndex + 2;

			$queryCom = db_query("
                                    select m.trns_type, d.currency_id, d.currency_name, d.unit_price, d.discount_rate_sell
                                    	, SUM(d.amount) as sell_amount, SUM(d.total) as sell_total
                                      from thtt_exchange_t_transaction_master m
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd
			    
                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'SELLING'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                                    and ut.uid = $user->uid
			                        and m.is_discount_booth = 'Y'
			                        and m.booth_cd = '$item->booth_cd'
                                    GROUP BY m.trns_type, d.currency_id, d.currency_name, d.unit_price, d.discount_rate_sell
                                    ORDER BY m.booth_cd, d.currency_name
                        		");

			$resultCom = $queryCom->fetchAll();
			foreach ($resultCom as $itemCom) {
				$com = (($itemCom->sell_total * $itemCom->unit_price) - ($itemCom->sell_total * $itemCom->discount_rate_sell));
				$comTotal += $com;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemCom->currency_name)->setCellValue('B' . $rowIndex, $itemCom->sell_total)->setCellValue('C' . $rowIndex, $itemCom->unit_price)->setCellValue('D' . $rowIndex, $itemCom->discount_rate_sell)->setCellValue('E' . $rowIndex, $com);

				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $hTableRow . ":E" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดคอมฯ')->setCellValue('E' . $rowIndex, $comTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":E" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Set Footer
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;
			/*
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดยกมา');
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเบิกเงินเพิ่ม')
			 * ->setCellValue('E'.$rowIndex, 'ยอดเงินรับซื้อจริง');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'รวมเป็นเงิน')
			 * ->setCellValue('E'.$rowIndex, 'ยอดจากเลจที่ถูกต้อง');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'หัก รวมยอดเงินรับซื้อ')
			 * ->setCellValue('E'.$rowIndex, 'สรุปให้เลจผิดเกิน');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเงินตามเอกสาร')
			 * ->setCellValue('E'.$rowIndex, 'สรุปเงินเกินจากยอดสรุป');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเงินที่นับได้จริง');
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเกิน');
			 */
			// End Set Footer od last sheet

			// Rename worksheet
			$bname = $item->booth_name;
			$bname = str_replace("/", "-", $bname);
			$objPHPExcel->getActiveSheet($sheetIndex)->setTitle($bname);
		}
		// Set width to All Sheet
		foreach ($objPHPExcel->getAllSheets() as $sheet) {
			$sheet->getColumnDimension('A')->setWidth(20);
			$sheet->getColumnDimension('B')->setWidth(15);
			$sheet->getColumnDimension('D')->setWidth(18);
			$sheet->getColumnDimension('E')->setWidth(15);
			$sheet->getColumnDimension('F')->setWidth(15);
			$sheet->getColumnDimension('G')->setWidth(20);
		}

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="SummaryReport_' . $trns_date . '.xlsx"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the followsing may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header('Expires: Mon, 26 Jul 2099 05:00:00 GMT'); // Date in the past
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->setPreCalculateFormulas(false);
		$objWriter->save('php://output');
		exit();
	} catch (Exception $e) {
		echo "<pre>";
		print_r($e);
		echo "</pre>";
	}
}

function _exchange_thaihappy_acc_report_today_excel_result_all() {
	global $user;
	global $_SESSION;

	$trns_date = $_POST['inDate'];

	$pdate = date('Y-m-d', strtotime('+1 day', strtotime($trns_date)));
	$date = new DateTime($pdate);
	$yyyy = $date->format('Y');
	$mm = $date->format('m');
	$dd = $date->format('d');
	$toDay = $yyyy . "-" . $mm . "-" . $dd;
	// echo ">> ". $trns_date;
	// exit(0);

	$fb_lib_path = function_exists('libraries_get_path') ? libraries_get_path('PHPExcel-1.8') : 'sites/all/libraries/PHPExcel-1.8';
	$fb_platform = $fb_lib_path . '/Classes/PHPExcel.php';

	try {

		$query2 = db_select('thtt_exchange_m_setting', 't');
		$query2->fields('t');
		$query2->condition('t.setting_key', "WORKING_CUT_OFF");
		$result2 = $query2->execute();

		$cutingTime = "03:00:00";
		foreach ($result2 as $item2) {
			$cutingTime = $item2->setting_value;
		}

		require_once $fb_platform;
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user->name)->setLastModifiedBy($user->name)->setTitle("Summary Exchange Report Today")->setSubject("Summary Exchange Report Today")->setDescription("Summary Exchange Report Today")->setKeywords("office 2007 openxml php")->setCategory("Summary Exchange Report");

		// Add some data
		$style = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				)
		);
		$style_left = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
				)
		);
		$style_right = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
				)
		);
		$style_border = array(
				'borders' => array(
						'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN
						)
				)
		);
		$style_border_solid = array(
				'font' => array(
						'bold' => true,
						'size' => 15
				)
		);

// 		$query = db_query("
//                                     select * from thtt_exchange_m_booth b
//                                     inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = b.tenant_cd
//                                     where ut.uid = " . $user->uid . "
//                                     order by b.tenant_cd, b.booth_name
//                             		");

		$sheetIndex = -1;
		$firstRec = true;
		$buyTotal = 0;
		$sellTotal = 0;
		$lastIndex = 0;
		$rowIndex = 8;

		// $result = $query->fetchAll();
		// foreach ($result as $item) {

			$query3 = db_query("
                                    select count(*) as count_trns from thtt_exchange_t_transaction_master m
                                    where m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                            		");
			$result3 = $query3->fetchAll();
			// echo "<pre>";
			// print_r($query3);
			// echo "</pre>";
			$chkZero = false;
			foreach ($result3 as $item3) {
				if ($item3->count_trns == 0) {
					$chkZero = true;
				}
			}

			if ($chkZero) {
				// continue;
			}

			$objPHPExcel->createSheet();

			// Start new sheet
			$buyTotal = 0;
			$sellTotal = 0;
			$sheetIndex = $sheetIndex + 1;
			$rowIndex = 6;

			// SET AUTO width
			// foreach(range('A','D') as $columnID) {
			// $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
			// ->setAutoSize(true);
			// }

			// Set style
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A2:D7")->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("B8:D999")->applyFromArray($style_right);
			$objPHPExcel->getActiveSheet()->getStyle('A6:D999')->getNumberFormat()->setFormatCode('#,##0.00');

			// Head and merge cell
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A2:D2');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A2', 'สรุปยอดการรับซื้ออัตราแลกเปลี่ยนเงินตราต่างประเทศ')->setCellValue('A4', 'ยอดประจำวันที่')->setCellValue('B4', $trns_date)->setCellValue('A5', '');

			// Header table of buying
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'BUYING');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':C' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('C' . ($rowIndex + 1), 'เลท')->setCellValue('B' . $rowIndex, 'ยอดรับซื้อ')->setCellValue('B' . ($rowIndex + 1), 'รับซื้อ')->setCellValue('D' . $rowIndex, 'ยอดรวม');

			$rowIndex = $rowIndex + 2;

			$queryBuying = db_query("
                                    select m.trns_type, d.currency_id, d.currency_name, d.unit_price
                                    	, SUM(d.amount) as buy_amount, SUM(d.total) as buy_total
                                      from thtt_exchange_t_transaction_master m
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd
                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'BUYING'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                                    and ut.uid = $user->uid
                                    GROUP BY m.trns_type,d.currency_id, d.currency_name, d.unit_price
                                    ORDER BY d.currency_name, d.unit_price
                        		");

			$resultBuying = $queryBuying->fetchAll();
			foreach ($resultBuying as $itemBuying) {
				$buyTotal += $itemBuying->buy_total;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemBuying->currency_name)->setCellValue('B' . $rowIndex, ($itemBuying->buy_amount))->setCellValue('C' . $rowIndex, $itemBuying->unit_price)->setCellValue('D' . $rowIndex, $itemBuying->buy_total);
				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดรับซื้อ')->setCellValue('D' . $rowIndex, $buyTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . ($hTableRow) . ":D" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":D" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Header table of Selling
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'SELLING');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $rowIndex . ":I" . ($rowIndex + 1))->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':C' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D' . $rowIndex . ':D' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('C' . ($rowIndex + 1), 'เลท')->setCellValue('B' . $rowIndex, 'ยอดนำส่ง')->setCellValue('B' . ($rowIndex + 1), 'ขาย')->setCellValue('D' . $rowIndex, 'ยอดรวม');

			$rowIndex = $rowIndex + 2;

			$querySelling = db_query("
                                    select m.trns_type, d.currency_id, d.currency_name, d.unit_price
                                    	, SUM(d.amount) as sell_amount, SUM(d.total) as sell_total
                                      from thtt_exchange_t_transaction_master m
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd
                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'SELLING'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                                    and ut.uid = $user->uid
                                    GROUP BY m.trns_type, d.currency_id, d.currency_name, d.unit_price
                                    ORDER BY d.currency_name, d.unit_price
                        		");

			$resultSelling = $querySelling->fetchAll();
			foreach ($resultSelling as $itemSelling) {
				$sellTotal += $itemSelling->sell_amount;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemSelling->currency_name)->setCellValue('B' . $rowIndex, ($itemSelling->sell_total))->setCellValue('C' . $rowIndex, $itemSelling->unit_price)->setCellValue('D' . $rowIndex, $itemSelling->sell_amount);

				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $hTableRow . ":D" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดขาย')->setCellValue('D' . $rowIndex, $sellTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":D" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Header table of Commission
			$comTotal = 0;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'Commission');
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;

			$hTableRow = $rowIndex;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $rowIndex . ":E" . ($rowIndex + 1))->applyFromArray($style);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A' . $rowIndex . ':A' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B' . $rowIndex . ':D' . $rowIndex);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E' . $rowIndex . ':E' . ($rowIndex + 1));
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'สกุลเงิน')->setCellValue('B' . $rowIndex, 'Commission (Selling)')->setCellValue('B' . ($rowIndex + 1), 'ขาย')->setCellValue('C' . ($rowIndex + 1), 'เลจปกติ')->setCellValue('D' . ($rowIndex + 1), 'Discount rate')->setCellValue('E' . $rowIndex, 'ค่าคอมฯ');

			$rowIndex = $rowIndex + 2;

			$queryCom = db_query("
                                    select m.trns_type, d.currency_id, d.currency_name, d.unit_price, d.discount_rate_sell
                                    	, SUM(d.amount) as sell_amount, SUM(d.total) as sell_total
                                      from thtt_exchange_t_transaction_master m
                                    inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
                                    left join thtt_exchange_m_booth h ON h.booth_cd = m.booth_cd
                                    inner join thtt_exchange_m_user_tenant ut ON ut.tenant_cd = h.tenant_cd
                                    WHERE m.flag_cancel = 'N'  and m.trns_type = 'SELLING'
                                    and m.trns_dttm > '$trns_date $cutingTime' and m.trns_dttm <= '$toDay $cutingTime'
                                    and ut.uid = $user->uid
			                        and m.is_discount_booth = 'Y'
                                    GROUP BY m.trns_type, d.currency_id, d.currency_name, d.unit_price, d.discount_rate_sell
                                    ORDER BY d.currency_name, d.unit_price
                        		");

			$resultCom = $queryCom->fetchAll();
			foreach ($resultCom as $itemCom) {
				$com = (($itemCom->sell_total * $itemCom->unit_price) - ($itemCom->sell_total * $itemCom->discount_rate_sell));
				$comTotal += $com;

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, $itemCom->currency_name)->setCellValue('B' . $rowIndex, $itemCom->sell_total)->setCellValue('C' . $rowIndex, $itemCom->unit_price)->setCellValue('D' . $rowIndex, $itemCom->discount_rate_sell)->setCellValue('E' . $rowIndex, $com);

				$rowIndex++;
			}

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A" . $hTableRow . ":E" . $rowIndex)->applyFromArray($style_border);
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->setCellValue('A' . $rowIndex, 'รวมยอดคอมฯ')->setCellValue('E' . $rowIndex, $comTotal);

			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A' . $rowIndex . ":E" . $rowIndex)->applyFromArray($style_border_solid);

			$rowIndex++;
			$rowIndex++;

			// Set Footer
			$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E' . $rowIndex)->applyFromArray($style_left);
			$rowIndex++;
			/*
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดยกมา');
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเบิกเงินเพิ่ม')
			 * ->setCellValue('E'.$rowIndex, 'ยอดเงินรับซื้อจริง');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'รวมเป็นเงิน')
			 * ->setCellValue('E'.$rowIndex, 'ยอดจากเลจที่ถูกต้อง');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'หัก รวมยอดเงินรับซื้อ')
			 * ->setCellValue('E'.$rowIndex, 'สรุปให้เลจผิดเกิน');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเงินตามเอกสาร')
			 * ->setCellValue('E'.$rowIndex, 'สรุปเงินเกินจากยอดสรุป');
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเงินที่นับได้จริง');
			 * $rowIndex++;
			 *
			 * $objPHPExcel->setActiveSheetIndex($sheetIndex)
			 * ->setCellValue('A'.$rowIndex, 'ยอดเกิน');
			 */
			// End Set Footer od last sheet

			// Rename worksheet
			$objPHPExcel->getActiveSheet($sheetIndex)->setTitle('All');
		// }
		// Set width to All Sheet
		foreach ($objPHPExcel->getAllSheets() as $sheet) {
			$sheet->getColumnDimension('A')->setWidth(20);
			$sheet->getColumnDimension('B')->setWidth(15);
			$sheet->getColumnDimension('D')->setWidth(18);
			$sheet->getColumnDimension('E')->setWidth(15);
			$sheet->getColumnDimension('F')->setWidth(15);
			$sheet->getColumnDimension('G')->setWidth(20);
		}

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		// Redirect output to a client
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="SummaryReport_' . $trns_date . '.xlsx"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the followsing may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header('Expires: Mon, 26 Jul 2099 05:00:00 GMT'); // Date in the past
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->setPreCalculateFormulas(false);
		$objWriter->save('php://output');
		exit();
	} catch (Exception $e) {
		echo "<pre>";
		print_r($e);
		echo "</pre>";
	}
}