<?php

/**
 * @author Bruno Massa http://drupal.org/user/67164
 * @file
 * Create true slideshows using any image over internet with many other features.
 */

/**
 * Module Tour settings page.
 */
function _exchange_thaihappy_superadmin_menu() {
	$output = "";

	// ---- Start HTML output -----
	$output .= '<div class="col-md-12 col-sm-12">
	<h3>Exchange Menu for Adminitrator</h3>
	</div>';

	$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';

	$output .= l('<input type="button" value="Booth Management" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/super/booth_management', array(
			'html' => TRUE
	));
	$output .= l('<input type="button" value="Tenant Management" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/super/setting_tenant', array(
			'html' => TRUE
	));
	$output .= l('<input type="button" value="Permission" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/super/setting_permissions', array(
			'html' => TRUE
	));

	return $output;
}

function exchange_setting_tenant() {
	global $user;
	global $base_url;

	$output = "";

	// ******* Start HTML *********
	// --------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="' . $base_url . '/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';

	// ------------ Content ----------------
	$output .= '	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="' . $base_url . '/admin/config/content/exchange_thaihappy/super/setting_tenant/submit">';
	$output .= '<div class="col-md-12 col-sm-12">
	<h2>Tenant Management</h2>
	</div>';

	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';

	// -------------- Detail ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';

	$output .= '
    <a href="' . $base_url . '/exchange_thaihappy/super/add_tenant">+ Add Tenant</a> 
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
		<th>Tenant Code</th>
		<th>Tenant Name</th>
		<th>Operations</th>
	</tr>
	</thead>
	<tbody>';

	$result = db_select('thtt_exchange_m_tenant', 'a')->fields('a')->execute();

	foreach ($result as $item) {
		$output .= "
		<tr>
		<td>$item->tenant_cd <input type='hidden' name='tenant_cd[]' value='" . $item->tenant_cd . "'/></td>
		<td><input type='text' name='tenant_name[]' value='" . $item->tenant_name . "'/></td>
		<td><a href='$base_url/exchange_thaihappy/super/delete_tenant/$item->tenant_cd'>Delete</a> 
		";
		$output .= "</tr>";
	}

	$output .= '
		</tbody>
		</table>
		';

	$output .= '</div>';

	$output .= '<div class="col-md-12 col-sm-12 form-entry">
		<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
		</div>';

	$output .= '</form>';

	return $output;
}

function exchange_setting_tenant_submit() {
	global $user;
	global $base_url;
	$output = "";

	for ($i = 0; $i < count($_POST['tenant_name']); $i++) {
		$tenantCD = trim($_POST['tenant_cd'][$i]);
		$tenantName = trim($_POST['tenant_name'][$i]);

		// ---- Add Detail ---------
		$detail_id = db_update('thtt_exchange_m_tenant')->fields(array(
				'tenant_name' => $tenantName
		))->condition("tenant_cd", $tenantCD)->execute();
	}

	drupal_set_message(t('Tenant config has changed.'));
	drupal_goto("$base_url/admin/config/content/exchange_thaihappy/super/setting_tenant");
	return $output;
}

function exchange_setting_permissions() {
	global $user;
	global $base_url;

	$output = "";

	// ******* Start HTML *********
	// --------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="' . $base_url . '/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';

	// ------------ Content ----------------
	$output .= '	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="' . $base_url . '/admin/config/content/exchange_thaihappy/super/setting_permissions/submit">';
	$output .= '<div class="col-md-12 col-sm-12">
	<h2>Permission Configuration</h2>
	</div>';

	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';

	// -------------- Detail ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';

	$result = db_select('thtt_exchange_m_tenant', 'a')->fields('a')->execute();

	$tenantCount = count($result);
	$tenantArr = array();
	$tenantIndex = 0;

	$output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
		<th rowspan="2" style="width:250px">Exchange User <div style="font-size:xx-smll; color:#BBB; font-weight:normal; ">All User</div></th>
        <th colspan="' . $tenantCount . '" style="text-align:center">Tenants</th>
    </tr>';

	$output .= "<tr>
    ";

	foreach ($result as $item) {
		$tenantArr[$tenantIndex++] = $item->tenant_cd;
		$output .= '<th>';
		$output .= $item->tenant_name;
		$output .= '</th>';
	}

	$output .= '
	</tr>
    
	</thead>
	<tbody>';

	$query = db_query("
                                select distinct u.* from users u
                                inner join users_roles ur on u.uid = ur.uid
                                inner join role r on ur.rid = r.rid
                                where (r.name like 'Exchange acc%' or r.name like 'Exchange admin%' or r.name like 'Exchange user') and u.uid <> 1
                                order by u.name
                            		");
	$result = $query->fetchAll();
	foreach ($result as $item) {
		$output .= "<tr>";
		$output .= "<td>$item->name <input type='hidden' name='uid[]' value='" . $item->uid . "'/></td>";

		foreach ($tenantArr as $tenantItem) {

			$result2 = db_select('thtt_exchange_m_user_tenant', 'a')->fields('a')->condition('uid', $item->uid)->condition('tenant_cd', $tenantItem)->execute();

			$chk = "";
			foreach ($result2 as $item2) {
				$chk = "checked=\"checked\" ";
			}
			$output .= "<td><input type='checkbox' name='tenant_" . $item->uid . "[]' value='$tenantItem' $chk /></td>";
		}

		$output .= "</tr>";
	}

	$output .= '
		</tbody>
		</table>
		';

	$output .= '</div>';

	$output .= '<div class="col-md-12 col-sm-12 form-entry">
		<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
		</div>';

	$output .= '</form>';

	return $output;
}

function exchange_setting_permissions_submit() {
	global $user;
	global $base_url;
	$output = "";

	print_r($_POST);

	for ($i = 0; $i < count($_POST["uid"]); $i++) {
		$uid = $_POST["uid"][$i];

		db_delete('thtt_exchange_m_user_tenant')->condition('uid', $uid)->execute();

		if (isset($_POST["tenant_" . $uid])) {
			for ($k = 0; $k < count($_POST["tenant_" . $uid]); $k++) {
				$tenant_cd = $_POST["tenant_" . $uid][$k];

				$detail_id = db_insert('thtt_exchange_m_user_tenant')->fields(array(
						'uid' => $uid,
						'tenant_cd' => $tenant_cd
				))->execute();
			}
		}
	}

	drupal_set_message(t('Permission configuration successfully'));
	drupal_goto("$base_url/admin/config/content/exchange_thaihappy/super/setting_permissions");
	return $output;
}

function exchange_setting_booth() {
}

function exchange_booth_add_submit() {
}



