<?php
/**
 * @author Bruno Massa http://drupal.org/user/67164
 * @file
 * Create true slideshows using any image over internet with many other features.
 */


/**
 * Module Tour settings page. 
 */
function _exchange_thaihappy_admin_menu(){
	
	$output = "";
	
	//---- Start HTML output -----
	$output .='<div class="col-md-12 col-sm-12">
	<h3>Exchange Menu for Adminitrator</h3>
	</div>';
	
	$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';
	
// 	$output .= l('<input type="button" value="List currency rate" class="btn btn-exchange col-md-6 col-sm-12"/>', '/exchange_thaihappy/rate_list', array('html' => TRUE, ));
// 	$output .= l('<input type="button" value="Set currency rate (Common)" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/admin/rate/add', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Booth configuration & Set Rate" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/admin/booth/config', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Setting Discount Sell Rate" class="btn btn-exchange col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/admin/setting_discount', array('html' => TRUE, ));
// 	$output .= l('<input type="button" value="Automatic set rate from BBL (time 8:30)" class="btn btn-exchange  col-md-6 col-sm-12"/>', '/admin/config/content/exchange_thaihappy/admin/rate/add_auto', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Logout" class="btn btn-exchange  col-md-6 col-sm-12"/>', '/user/logout', array('html' => TRUE, ));
	
	return $output;
}



function _exchange_thaihappy_admin_booth_config(){
	global $user;
	global $base_url;
	
	$output = "";
	
	//******* Start HTML *********
	//--------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="'.$base_url.'/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';
	
	
	//------------ Content ----------------
	$output .='	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="'.$base_url.'/admin/config/content/exchange_thaihappy/admin/booth/config/submit">';
	$output .='<div class="col-md-12 col-sm-12">
	<h2>Booth Configuration</h2>
	</div>';
	
	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';
	
	
	//-------------- Detail ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';
	
	$output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
		<th>Booth Code</th>
		<th>Booth Name</th>
		<!--<th>Use Common Rate <div style="font-size:xx-smll; color:#BBB; font-weight:normal; ">Yes = use common rate <BR/> No = use branch rate</div>
                <a href="'.$base_url.'/admin/config/content/exchange_thaihappy/admin/rate/add">Set Common Rate</a>
        </th>-->
		<th>Operations</th>
	</tr>
	</thead>
	<tbody>';
	
	
	$query = db_select('thtt_exchange_m_booth','b');
	$query->join('thtt_exchange_m_user_tenant', 'ut', 'ut.tenant_cd = b.tenant_cd');
	$result = $query
	->fields('b')
	->condition('ut.uid',$user->uid)
	->condition('b.is_enable','Y')
	->execute();
	
	foreach($result as $item) {
		$output .= "
		<tr>
		<td>$item->booth_cd <input type='hidden' name='booth_cd[]' value='$item->booth_cd '/></td>
		<td>$item->booth_name </td>";
		
		$output .="<td><a href='$base_url/exchange_thaihappy/rate_list/$item->booth_cd'>View Rate</a>";
		$output .="| <a href='$base_url/admin/config/content/exchange_thaihappy/admin/rate/add_booth/$item->booth_cd'>Set Rate</a> </td>";
		$output .="</tr>";
	}
	
	$output .= '
		</tbody>
		</table>
		';
	
		$output .= '</div>';
	
		/*
		$output .= '<div class="col-md-12 col-sm-12 form-entry">
		<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
		</div>';
	*/
		$output .= '</form>';
	
		return $output;	
}

function _exchange_thaihappy_admin_booth_config_submit() {
	global $user;
	global $base_url;
	$output = "";


	drupal_set_message(t('Booth config has changed.'));
	drupal_goto("$base_url/admin/config/content/exchange_thaihappy/admin/booth/config");
	return  $output;
}




function _exchange_thaihappy_admin_rate_add_booth($booth_cd) {
	global $user;
	global $base_url;

	$docNo = "";
	$output = "";

	
	$result = db_select('thtt_exchange_m_booth','a')
	->fields('a')
	->condition("booth_cd",$booth_cd)
	->execute();
	
	$booth_name = "";
	foreach($result as $item) {
		$booth_name = $item->booth_name;
	}


	//******* Start HTML *********

	//--------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="'.$base_url.'/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';

	//--------- Javascript ----------
	$output .= '
	<script type="text/javascript">
	$(document).ready(function(){

	var dateToday = new Date();
	$("#rate_date").val(dateToday.getFullYear()+"-"+ (dateToday.getMonth() + 1)+"-"+ dateToday.getDate());

/*
    var dates = $("#rate_date").datepicker({
        	changeMonth: true,
        	numberOfMonths: 1,
        	// 		      minDate: dateToday,
        	dateFormat: \'yy-mm-dd\',
        	onSelect: function(selectedDate) {
            	var option = this.id == "rate_date" ? "minDate" : "maxDate",
            	instance = $(this).data("datepicker"),
            	date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
            	dates.not(this).datepicker("option", option, date);
        }
     });
    */
    
    $("#btn_copyrate").click(function(){
            var copy_booth_cd = $("#copy_booth_cd").val();
            if(confirm("Do you want continue to process? \nAll existing rate will be changed.")){
			    window.location.href = "'.$base_url.'/admin/config/content/exchange_thaihappy/rate_copy/'.$booth_cd.'/"+copy_booth_cd;
            }
    });

});


    function checkSubmit(){
        if($("#rate_date").val() == ""){
            alert("Pease select date.");
        return false;
        }
        return true;
    }
</script>
';
	
	$result = db_select('thtt_exchange_m_booth','a')
	->fields('a')
	->condition('is_enable','Y')
	->orderBy("booth_name","ASC")
	->execute();
	
	$boothOption = '<select id="copy_booth_cd" name="copy_booth_cd" class="form-control" style="width:70%;">';
	foreach($result as $item) {
	    if($item->booth_cd != $booth_cd){
	        $boothOption .= '<option value="'.$item->booth_cd .'">'.$item->booth_name.'</option>';
	    }
	}
	$boothOption .= '</select>';
	
	
	//------------ Content ----------------
	$output .='	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="'.$base_url.'/admin/config/content/exchange_thaihappy/admin/rate/add_booth_submit">';
	$output .='<div class="col-md-12 col-sm-12">
	<h2>Set currency rate for '.$booth_name.'</h2>
	</div>';

	$output .='<div class="col-md-12 col-sm-12"></div>';

	$output .='
    <div class="col-md-2 col-sm-5 form-label text-left">
	       Rate date:
	</div>
	<div class="col-md-3 col-sm-7 form-entry">
	   <input id="rate_date" name="rate_date" type="text" value="" readonly="readonly" style="width: 80%;">
	   <input type="hidden" name="booth_cd" value="'.$booth_cd.'"/>
	</div>
    <div class="col-md-2 col-sm-5 form-label text-left">
	    Copy rate from :
	</div>
	<div class="col-md-2 col-sm-7 form-entry">
	   '.$boothOption.'
	</div>
	<div class="col-md-2 col-sm-7 form-entry">
	   <input type="button" id="btn_copyrate" name="btn_copyrate" value="Copy" class="form-submit"/>
	</div>
    ';


	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';


	//-------------- Detail ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';

	$output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
	<th>Country</th>
	<th>Currency</th>
	<th>Buy price</th>
	<th>Sell price</th>
	</tr>
	</thead>
	<tbody>';


	$result = db_select('thtt_exchange_m_currency','a')
	->fields('a')
	->condition("currency_default","N")
	->condition("is_enable","Y")
	->orderBy('seq')
	->orderBy('currency_name')
	->execute();

	foreach($result as $item) {
		$result2 = db_select('thtt_exchange_m_currency_branch','a')
		->fields('a')
		->condition("currency_id", $item->currency_id)
		->condition("booth_cd", $booth_cd)
		->execute();

		$buy = 0;
		$sell =0;
		foreach($result2 as $item2) {
			$buy = $item2->rate_buy;
			$sell = $item2->rate_sell;
			break;
		}

		$output .= "
		<tr>
		<td>$item->country</td>
		<td>$item->currency_name <input type='hidden' name='curr[]' value='$item->currency_id' /></td>
		<td><input type='text' name='buy_price[]' class='form-entry' value='$buy'/></td>
		<td><input type='text' name='sell_price[]' class='form-entry' value='$sell'/></td>
		</tr>";
	}

	$output .= '
	</tbody>
	</table>
	';

	$output .= '</div>';

	$output .= '<div class="col-md-12 col-sm-12 form-entry">
	<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
	</div>';

	$output .= '</form>';

	return $output;
}


function _exchange_thaihappy_admin_rate_add_booth_submit() {
	global $user;
	global $base_url;
	$output = "";

	$booth_cd = $_POST['booth_cd'];

	db_delete('thtt_exchange_m_currency_branch')
			->condition('booth_cd',$booth_cd)
			->execute();


	for($i=0; $i<count($_POST['curr']); $i++){
		$curr = $_POST['curr'][$i];
		$buy_price = $_POST['buy_price'][$i];
		$sell_price = $_POST['sell_price'][$i];

		if($buy_price != ""){
			if($sell_price==""){
				$sell_price = "0.0";
			}
				
			// Get Currency name
			$query = db_select('thtt_exchange_m_currency','a');
			$result = $query
			->fields('a')
			->condition('a.currency_id',$curr)
			->execute();

			$currency_name = "";
			foreach($result as $item) {
				$currency_name = $item->currency_name;
			}

			//---- Add Detail ---------
			$detail_id = db_insert('thtt_exchange_m_currency_branch')
			->fields(array(
					'currency_id' => $curr,
					'booth_cd' => $booth_cd,
					'currency_name' => $currency_name,
					'rate_buy' => $buy_price,
					'rate_sell' => $sell_price,
					'create_by' => $user->uid,
					'create_dttm' => date("Y-m-d H:i:s", time()),
					'update_by' => $user->uid,
					'update_dttm' => date("Y-m-d H:i:s", time())
			))
			->execute();
		}
	}


//Keep History
	$rate_date = $_POST['rate_date'];
	$rate_time = 0; //$_POST['rate_time'];

	//---- Add Master ---------
	$master_id = db_insert('thtt_exchange_t_rate_current_branch_master') // Table name no longer needs {}
	->fields(array(
			'curr_date' => $rate_date,
			'curr_time_id' => $rate_time,
			'booth_cd' => $booth_cd,
			'create_by' => $user->uid,
			'create_dttm' => date("Y-m-d H:i:s", time())
	))
	->execute();

	// Get Time
	$query = db_select('thtt_exchange_m_curr_time','a');
	$result = $query
	->fields('a')
	->condition('a.curr_time_id',$rate_time)
	->execute();

	$curr_time_name = "00:00:00";
	foreach($result as $item) {
		$curr_time_name = $item->curr_time_name;
	}

	for($i=0; $i<count($_POST['curr']); $i++){
		$curr = $_POST['curr'][$i];
		$buy_price = $_POST['buy_price'][$i];
		$sell_price = $_POST['sell_price'][$i];

		if($buy_price != ""){
			if($sell_price==""){
				$sell_price = "0.0";
			}
				
			// Get Currency name
			$query = db_select('thtt_exchange_m_currency','a');
			$result = $query
			->fields('a')
			->condition('a.currency_id',$curr)
			->execute();

			$currency_name = "";
			foreach($result as $item) {
				$currency_name = $item->currency_name;
			}

			//---- Add Detail ---------
			$detail_id = db_insert('thtt_exchange_t_rate_current_branch')
			->fields(array(
					'rate_current_branch_master_id' => $master_id,
					'currency_id' => $curr,
					'currency_name' => $currency_name,
					'buy_price' => $buy_price,
					'sell_price' => $sell_price,
					'rate_dttm' => $rate_date." ".$curr_time_name,
					'create_by' => $user->uid,
					'create_dttm' => date("Y-m-d H:i:s", time()),
					'update_by' => $user->uid,
					'update_dttm' => date("Y-m-d H:i:s", time())
			))
			->execute();
		}
	}

	drupal_set_message(t('Currency rate has changed.'));
	drupal_goto("$base_url/exchange_thaihappy/rate_list/".$booth_cd);
	return  $output;
}



function _exchange_thaihappy_admin_rate_add() {
	global $user;
	global $base_url;
	
	$docNo = "";
	$output = "";
	
	//--------- Booth Options -----------
	$result = db_select('thtt_exchange_m_booth','a')
	->fields('a')
	->execute();
		
	//----------- Currency Time------------
	$result = db_select('thtt_exchange_m_curr_time','a')
	->fields('a')
	->execute();
	
	$currTime = '<select id="rate_time" name="rate_time" class="form-control" style="width:70%;">';
	foreach($result as $item) {
		$chk = "";
		$currTime .= '<option value="'.$item->curr_time_id .'" '.$chk.'>'.$item->curr_time_name.'</option>';
	}
	$currTime .= '</select>';
	
	//******* Start HTML *********
	
	//--------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="'.$base_url.'/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';
	
	//--------- Javascript ----------
	$output .= '
	<script type="text/javascript">
	$(document).ready(function(){
		
		var dateToday = new Date();
		$("#rate_date").val(dateToday.getFullYear()+"-"+ (dateToday.getMonth() + 1)+"-"+ dateToday.getDate());
		var dates = $("#rate_date").datepicker({
		changeMonth: true,
		numberOfMonths: 1,
		// 		      minDate: dateToday,
		dateFormat: \'yy-mm-dd\',
		onSelect: function(selectedDate) {
		var option = this.id == "rate_date" ? "minDate" : "maxDate",
		instance = $(this).data("datepicker"),
		date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
		dates.not(this).datepicker("option", option, date);
		}
		});
	});
	
	function checkSubmit(){
		if($("#rate_date").val() == ""){
			alert("Pease select date.");
			return false;
		}
		
			return true;
	}
	</script>
	';
	
	//------------ Content ----------------
	$output .='	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="'.$base_url.'/admin/config/content/exchange_thaihappy/admin/rate/add/submit">';
	$output .='<div class="col-md-12 col-sm-12">
	<h2>Update common rate</h2>
	</div>';
	
	$output .='<div class="col-md-12 col-sm-12"></div>';
	
	$output .='<div class="col-md-3 col-sm-5 form-label text-left">
	Rate date time:
	</div>
	<div class="col-md-4 col-sm-7 form-entry">
		<input id="rate_date" name="rate_date" type="text" value="" readonly="readonly" style="width: 80%; cursor: pointer;">
	</div>';
	
	
	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';
	
	
	//-------------- Detail ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';

	$output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr>
	<th>Country</th>
	<th>Currency</th>
	<th>Buy price</th>
	<th>Sell price</th>
	</tr>
	</thead>
	<tbody>';
	
	
	$result = db_select('thtt_exchange_m_currency','a')
	->fields('a')
	->condition("currency_default","N")
	->execute();
	
	foreach($result as $item) {
		$output .= "
						<tr>
						<td>$item->country</td>
						<td>$item->currency_name <input type='hidden' name='curr[]' value='$item->currency_id' /></td>
						<td><input type='text' name='buy_price[]' class='form-entry' value='$item->rate_buy'/></td>
						<td><input type='text' name='sell_price[]' class='form-entry' value='$item->rate_sell'/></td>
						</tr>";
	}
	
	$output .= '
	</tbody>
	</table>
	';
	
	$output .= '</div>';
	
	$output .= '<div class="col-md-12 col-sm-12 form-entry">
	<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
	</div>';
	
	$output .= '</form>';
	
	return $output;
}

function _exchange_thaihappy_admin_rate_add_auto() {
	global $user;
	global $base_url;
	
	$chkResut= false;
	
	$urlGetLastUpdate = "http://www.bangkokbank.com/UserControls/ExchangeRates/ExchangeRates.asmx/GetfxratesLastUpdate";
	$jsonData = array();
	$resultLastUpdate = sendPostData($urlGetLastUpdate, $jsonData);
	$resultLastUpdateJson = json_decode($resultLastUpdate);
	
	$date = new DateTime();
	$yyyy = $date->format('Y');
	$mm = $date->format('m');
	$dd = $date->format('d');
	$today = $yyyy."-".$mm."-".$dd;
	
	$pdate = date('Y-m-d', strtotime('-1 day', strtotime($today)));
	$date = new DateTime($pdate);
	$yyyy = $date->format('Y');
	$mm = $date->format('m');
	$dd = $date->format('d');
	$today = $yyyy."-".$mm."-".$dd;
	
// 	echo "<pre>";
// 	print_r ($resultLastUpdate);
// 	echo "</pre>";
	
	foreach($resultLastUpdateJson->d as $row){
		$dArr = explode ("/",$row->Day);
		$yyyy = $dArr[2];
		$mm = $dArr[1];
		$dd = $dArr[0];
		$today = $yyyy."-".$mm."-".$dd;
		break;
	}
// 	echo $today;
	
	$url = "http://www.bangkokbank.com/UserControls/ExchangeRates/ExchangeRates.asmx/Getfxrates";
	
	//The JSON data.
	$jsonData = array (
			'dd' => $dd,
			'mm' => $mm,
			'yyyy' => $yyyy,
			'upd' => 1,
			'Lang' => 'En'
	);
	$result = sendPostData($url, $jsonData);
	
	$resultJson = json_decode($result);
	// 	print_r($resultJson);
	

	//Insert Data
	$rate_date = $today;
	$rate_time = 1;
		
	//---- Add Master ---------
	$master_id = db_insert('thtt_exchange_t_rate_current_master') // Table name no longer needs {}
	->fields(array(
			'curr_date' => $rate_date,
			'curr_time_id' => $rate_time,
			'create_by' => $user->uid,
			'create_dttm' => date("Y-m-d H:i:s", time())
	))
	->execute();
		
	// Get Time
	$query = db_select('thtt_exchange_m_curr_time','a');
	$result = $query
	->fields('a')
	->condition('a.curr_time_id',$rate_time)
	->execute();
		
	$curr_time_name = "00:00:00";
	foreach($result as $item) {
		$curr_time_name = $item->curr_time_name;
	}
	
	foreach($resultJson->d as $row){
		
		$curr = $row->Family;
		if($curr == "USD1"){
			$curr = "USD1-2";
		}else if($curr == "USD5"){
			$curr = "USD5-20";
		}else if($curr == "USD50"){
			$curr = "USD50-100";
		}
		
		//Sync my currency in DB
		$resultDB = db_select('thtt_exchange_m_currency','a')
		->fields('a')
		->condition("currency_name", $curr)
		->range(0,1)
		->execute();
		
		foreach($resultDB as $item) {
				$curr = $curr;
				$buy_price = $row->BuyingRates;
				$sell_price = $row->SellingRates;
			
				if($buy_price != ""){
					if($sell_price==""){
						$sell_price = "0.0";
					}
					
					if(strpos($row->Description, ":1000") > -1){
						$buy_price = $row->BuyingRates / 1000;
						$sell_price = $row->SellingRates / 1000;
					}else if(strpos($row->Description, ":100") > -1){
						$buy_price = $row->BuyingRates / 100;
						$sell_price = $row->SellingRates / 100;
					}
					
					//---- Add Detail ---------
					$detail_id = db_insert('thtt_exchange_t_rate_current')
					->fields(array(
							'rate_current_master_id' => $master_id,
							'currency_id' => $item->currency_id,
							'currency_name' => $curr,
							'buy_price' => $buy_price,
							'sell_price' => $sell_price,
							'rate_dttm' => $rate_date." ".$curr_time_name,
							'create_by' => $user->uid,
							'create_dttm' => date("Y-m-d H:i:s", time()),
							'update_by' => $user->uid,
							'update_dttm' => date("Y-m-d H:i:s", time())
					))
					->execute();
					$chkResut = true;
				}
			}
		
	}
	
// 	echo "<pre>";
// 	print_r ($resultJson->d);
// 	echo "</pre>";

// 	if($chkResut){
// 		echo '{"status" : "OK"}';
// 	}else{
// 		echo '{"status" : "Fail"}';
// 	}

	drupal_set_message(t('Currency rate has changed by automatically synchonize from BBL.'));
 	drupal_goto("$base_url/exchange_thaihappy/rate_list");
	return  $output;
}

function sendPostData($url, $jsonData){
	//Initiate cURL.
	$ch = curl_init($url);
	//Encode the array into JSON.
	$jsonDataEncoded = json_encode($jsonData);
	//Tell cURL that we want to send a POST request.
	curl_setopt($ch, CURLOPT_POST, 1);
	//Attach our encoded JSON string to the POST fields.
	if(count($jsonData)==0){
		curl_setopt($ch, CURLOPT_POSTFIELDS, "{}");		
	}else{
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
	}
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	//Set the content type to application/json
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	//Execute the request
	$result = curl_exec($ch);
	curl_close($ch);  // Seems like good practice
	return $result;
}

function _exchange_thaihappy_admin_rate_add_submit() {
	global $user;
	global $base_url;
	$output = "";
	


	for($i=0; $i<count($_POST['curr']); $i++){
		$curr = $_POST['curr'][$i];
		$buy_price = $_POST['buy_price'][$i];
		$sell_price = $_POST['sell_price'][$i];

		if($buy_price != ""){
			if($sell_price==""){
				$sell_price = "0.0";
			}
				
			$nid = db_update('thtt_exchange_m_currency') // Table name no longer needs {}
				->fields(array(
						'rate_buy' => $buy_price,
						'rate_sell' => $sell_price,
						'update_by' => $user->name,
						'update_dttm' => date("Y-m-d H:i:s", time())
				)) 
				->condition('currency_id', $curr)
				->execute();
		}
	}


	//Keep History
	$rate_date = $_POST['rate_date'];
	$rate_time = 0; //$_POST['rate_time'];
	
	//---- Add Master ---------
	$master_id = db_insert('thtt_exchange_t_rate_current_master') // Table name no longer needs {}
	->fields(array(
			'curr_date' => $rate_date,
			'curr_time_id' => $rate_time,
			'create_by' => $user->uid,
			'create_dttm' => date("Y-m-d H:i:s", time())
	))
	->execute();

	// Get Time
	$query = db_select('thtt_exchange_m_curr_time','a');
	$result = $query
	->fields('a')
	->condition('a.curr_time_id',$rate_time)
	->execute();
		
	$curr_time_name = "00:00:00";
	foreach($result as $item) {
		$curr_time_name = $item->curr_time_name;
	}
		
	for($i=0; $i<count($_POST['curr']); $i++){
		$curr = $_POST['curr'][$i];
		$buy_price = $_POST['buy_price'][$i];
		$sell_price = $_POST['sell_price'][$i];

		if($buy_price != ""){
			if($sell_price==""){
				$sell_price = "0.0";
			}
			
			// Get Currency name
			$query = db_select('thtt_exchange_m_currency','a');
			$result = $query
			->fields('a')
			->condition('a.currency_id',$curr)
			->execute();
				
			$currency_name = "";
			foreach($result as $item) {
				$currency_name = $item->currency_name;
			}
				
			//---- Add Detail ---------
			$detail_id = db_insert('thtt_exchange_t_rate_current')
			->fields(array(
					'rate_current_master_id' => $master_id,
					'currency_id' => $curr,
					'currency_name' => $currency_name,
					'buy_price' => $buy_price,
					'sell_price' => $sell_price,
					'rate_dttm' => $rate_date." ".$curr_time_name,
					'create_by' => $user->uid,
					'create_dttm' => date("Y-m-d H:i:s", time()),
					'update_by' => $user->uid,
					'update_dttm' => date("Y-m-d H:i:s", time())
			))
			->execute();
		}
	}
	
	drupal_set_message(t('Currency rate has changed.'));
 	drupal_goto("$base_url/exchange_thaihappy/rate_list");
	return  $output;
}

/**
 * Module edit tour package page. Users can edit tour as requested.
 *
 * @ingroup form
 */
function _exchange_thaihappy_admin_rate_edit_form($form, $form_state, $tour_id) {
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$result = $query
	->fields('t')
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();
	
	foreach($result as $item) {
		// Build the form
		
		$form['tour_id'] = array(
				'#type' => 'hidden',
				'#value' => $tour_id,
		);
		
		//---------- Get Category list ---------
		$result = db_select('thtt_m_tour_category','a')
	  	->fields('a', array('tour_category_id','tour_category_name'))
		->execute();
		
		$categoryOption = array();
		
		foreach($result as $item2) {
			$categoryOption[$item2->tour_category_id] = t($item2->tour_category_name);
		}
		
		$form['tour_category_id'] = array(
				'#default_value'  => $item->tour_category_id,
				'#description'    => t('Tour category'),
				'#title'          => t('Tour Category'),
				'#type'           => 'select',
				'#options'        => $categoryOption,
				'#required' => TRUE,
		);

		$displayOrder = array();
		for($n=1; $n<=20; $n++){
			$displayOrder[$n] = $n;
		}
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying on packaging tour.'),
				'#title'          => t('Display order'),
				'#type'           => 'select',
				'#options'        => $displayOrder,
	    		'#required' => TRUE,
		);
		$form['tour_picture_cover_path'] = array(
				'#default_value'  => $item->tour_picture_cover_path,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture cover'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
				'#upload_validators' => array(
						'file_validate_extensions' => array("png jpg jpeg gif"),
				),
		);
		$form['tour_picture_path'] = array(
				'#default_value'  => $item->tour_picture_path,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
				'#upload_validators' => array(
						'file_validate_extensions' => array("png jpg jpeg gif"),
				),
		);
		$form['tour_name'] = array(
				'#default_value'  => $item->tour_name,
				'#description'    => t('Tour name (Limit 255 Character)'),
				'#title'          => t('Tour name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
				'#attributes' => array('onKeyPress' => "return(this.value.length<255)"),
		);
		$form['tour_short_desc'] = array(
				'#default_value'  => $item->tour_short_desc,
				'#description'    => t('Short description, limit 500 character.'),
				'#title'          => t('Tour short description'),
				'#type' => 'textarea',
				'#required' => TRUE,
				'#attributes' => array('onKeyPress' => "return(this.value.length<500)"),
		);
		

// 		$form['nid'] = array(
// 				'#default_value'  => $item->nid,
// 				'#description'    => t('Link page'),
// 				'#title'          => t('Link page'),
// 				'#type'           => 'select',
// 				'#options'        => $nodeOption,
// 				'#required' => TRUE,
// 		);


		$form['nid'] = array(
				'#type' => 'hidden',
				'#value' => $item->nid,
		);
		
		// load node
		$nodeLoad = node_load($item->nid);

		$form['tour_content'] = array(
				'#default_value'  => $nodeLoad->body['und'][0]['value'],
				'#description'    => t('Full content description'),
				'#title'          => t('Full content description'),
				'#type' => 'text_format',
				'#format' => 'full_html',
				'#required' => TRUE,
				'#rows' => '18'
		);
		
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save'),
				'#type'           => 'submit',
		);
	}
  return ($form);
}


/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _exchange_thaihappy_admin_rate_edit_form_submit($form, &$form_state) {
	
	if(!isset($form_state['values']['tour_picture_path']) || $form_state['values']['tour_picture_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_path']);
	}
	
	if(!isset($form_state['values']['tour_picture_cover_path']) || $form_state['values']['tour_picture_cover_path'] > 0){
		$file = file_load($form_state['values']['tour_picture_cover_path']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_cover_path']);
	}

	/*
	 * *********** Update new Node **************
	 */
	global $user;
	
	/*
	 * Set URL Alias name
	 */
	$aliasURL = str_replace(' ', '-', $form_state['values']['tour_name']);
	$aliasURL = str_replace('_', '-', $aliasURL);
	$aliasURL = preg_replace('/[^A-Za-z0-9\-]/', '', $aliasURL); // Removes special chars.
	
	$node = new stdClass();
	$node->nid = $form_state['values']['nid'];
	$node->title = $form_state['values']['tour_name'];
	$node->type = "tour_content";
	node_object_prepare($node); // Sets some defaults. Invokes hook_prepare() and hook_node_prepare().
	$node->language = LANGUAGE_NONE; // Or e.g. 'en' if locale is enabled
	$node->uid = $user->uid;
	$node->status = 1; //(1 or 0): published or not
	$node->promote = 0; //(1 or 0): promoted to front page
	$node->comment = 1; // 0 = comments disabled, 1 = read only, 2 = read/write
	$node->body[$node->language][0]['value'] = $form_state['values']['tour_content']['value'];
	$node->body[$node->language][0]['summary'] = '';
	$node->body[$node->language][0]['format'] = $form_state['values']['tour_content']['format'];
	$node->path['alias'] = $aliasURL;
	
	if ($node = node_submit($node)) {
		node_save($node);
	}
	//drupal_set_message( "Node with nid " . $node->nid . " saved!\n");
	
	/*
	 * ***** Update Tour *****
	 */
	$nid = db_update('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'tour_desc' => $form_state['values']['tour_desc'],
			'nid' => $form_state['values']['nid'],
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'tour_picture_cover_path' => $form_state['values']['tour_picture_cover_path'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $user->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $user->name,
			'update_date' => date("Y-m-d H:i:s", time())
	)) 
	->condition('tour_id', $form_state['values']['tour_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
	 
}


/**
 * Form builder for a tour delete
 */
function _exchange_thaihappy_admin_rate_delete_form($form, $form_state, $tid, $tname) {
	$form = array();

	$form['_tour_id'] = array(
			'#type' => 'value',
			'#value' => $tour_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete tour <strong>%profile</strong>?', array(
							'%profile' => urldecode($tour_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _exchange_thaihappy_admin_rate_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_tour')
		->condition('tour_id', $v['_tour_id'])
		->execute();
		
		drupal_set_message(t('The tour was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/package_tour/tour';
}


function _exchange_thaihappy_admin_rate_list($form, $form_state) {

	/*
	 * ******* List of programs tour ************
	 */
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$query->leftJoin('thtt_m_program', 'p', 'p.tour_id = t.tour_id');
	$result = $query
	->fields('p')
	->fields('t', array('tour_name','tour_picture_cover_path'))
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();

	$tourName = "";
	$imgId = "";
	$options = array();
	foreach ($result as $itemNode) {
		$tourName = $itemNode->tour_name;
		$imgId = $itemNode->tour_picture_cover_path;
		
		if($itemNode->prog_id != ""){
			$options[$itemNode->prog_id] = array(
					'display_order' => $itemNode->display_order,
					'prog_name' => $itemNode->prog_name,
					'price_adult' => $itemNode->price_adult,
					'price_child' => $itemNode->price_child,
					'price_new_adult' => $itemNode->price_new_adult,
					'price_new_child' => $itemNode->price_new_child,
					'operation' => l("Edit", 'admin/config/content/package_tour/tour/program/edit/' . $itemNode->prog_id )
			);
		}
	}
	
	$form['tour']['#markup'] = "<h3><b>Tour name : </b> $tourName </h3><BR/>";

	$form['tour_id'] = array(
			'#type' => 'hidden',
			'#value' => $tour_id,
	);
	
	try{
		if($imgId != 0 && $imgId != ""){
			$img = file_create_url(file_load($imgId)->uri);
			$variables = array(
					'path' => $img,
					'alt' => '',
					'title' => '',
					'width' => '200px',
					'height' => '',
					'attributes' => array('class' => 'tour-img-item')
			);
			$form['tour_img']['#markup'] = theme('image', $variables)."<BR/><HR/><BR/>";
		}else{
			$img = "";
		}
	}catch (Exception $e) {
	}
	
	$form['_tour_id'] = array(
			'#type' => 'value',
			'#value' => $tour_id,
	);

	$form['add']['#markup'] = l('<input type="button" value="Add new program price" class="form-submit"/>', 'admin/config/content/package_tour/tour/program/' . urlencode($tour_id) .'/add', array('html' => TRUE, ));

	// del button
	$form['del_submit'] = array(
			'#value'          => t('Delete'),
			'#type'           => 'submit',
			'#attributes' => array('onClick' => "return confirm('Are you sure for delete items?')"),
	);
	
	
	$header = array(
			'prog_name' => t('Program name'),
			'display_order' => t('Display order'),
			'price_adult' => t('Price old adult'),
			'price_child' => t('price old child'),
			'price_new_adult' => t('Price new adult'),
			'price_new_child' => t('price new child'),
			'operation' => t('Operation'),
	);

	$form['table'] = array(
			'#type' => 'tableselect',
			'#header' => $header,
			'#options' => $options,
			'#empty' => t('Not found'),
			'#description'    => t('List of programs'),
			'#title'          => t('Programs'),
	);

	return ($form);
}




/*
 * ************************************** Transaction ***************************************************
 */


function package_tour_admin_transaction($ghi = 0, $jkl = '') {
	$output = "";
	$ref_code = "";

	if(isset($_GET['ref_code'])){
		$ref_code = $_GET['ref_code'];
	}

	$query = db_select('thtt_t_reservation','t');
	$query->leftJoin('thtt_t_reservation_detail', 'd', 't.rsvn_id = d.rsvn_id');
	$query->fields('t')
	->fields('d');
	//->fields('ty', array('type_name'));
	//$query->addField('d1', 'dest_name', 'dest_from_name');
	//$query->addField('d2', 'dest_name', 'dest_to_name');

	if($ref_code != ""){
		$query->condition('t.rsvn_ref', '%' . db_like($ref_code) . '%', 'LIKE');
	}

	$query->orderBy('t.rsvn_ref', 'DESC');
	$result = $query->execute();

	$output .= '<h4>'.t('Search').'</h4>';
	$output .= '<form>';
	$output .= t('Ref code').' : '.' <input type="text" name="ref_code" value="'.$ref_code.'" style="border: solid 1px #000000; line-height: 20px;"/> <input type="submit" name="search" vale="'.t('Search').'" style="width:80px; height:28px; border: solid 1px #000000; "/>';
	$output .= '</form>';
	$output .= '<BR/><BR/>';


	$header = array(t('Operations'), t('Ref code'), t('Customer name'), t('Customer contact')
			, t('Tour information'), t('Number of Adult'), t('Total price (THB)')
			, t('Status'), t('Create date'));
		
	foreach($result as $item) {
		 
		$status = "";
		if($item->rsvn_status == 1){
			$status = "Unpaid";
		}else if($item->rsvn_status == 2){
			$status = "Paid";
		}

		$rows[] = array(
				array(
						'data' =>
						l('<input type="button" value="Close job" class="form-submit"/>',  'admin/config/content/package_tour/transaction/finish/' . urlencode($item->rsvn_id), array('html'=> TRUE)) 
						." <BR/>". l('<input type="button" value="View detail" class="form-submit"/>', 'admin/config/content/package_tour/transaction/detail/' . urlencode($item->rsvn_id), array('html'=>TRUE)) ,
						'valign' => 'top'
				),
				array('data' => $item->rsvn_ref, 'valign' => 'top'),
				array('data' => "$item->rsvn_guest_title.$item->rsvn_guest_fname $item->rsvn_guest_lname <BR/>($item->rsvn_nationality) <BR/> (<b>IP:</b> $item->rsvn_ip)" , 'valign' => 'top'),
				array('data' => "<b>Tel :</b> $item->rsvn_tel <BR/> <b>email:</b> $item->rsvn_email", 'valign' => 'top'),
				 
				array('data' => "<b>Tour name:</b> $item->tour_name <BR/>  <b>Program:</b> $item->prog_name <BR/> <b>Travel Date:</b> $item->rsvn_travel_date", 'valign' => 'top'),
				array('data' => '<b>Adult:</b> '.$item->rsvn_adult.' <BR/> <b>Child:</b> '.$item->rsvn_child.'<BR/> <b>Infant:</b> '.$item->rsvn_infant, 'valign' => 'top'),
				array('data' => $item->rsvn_price_total." ".$item->currency_cd, 'valign' => 'top'),
				 
				array('data' => t($status), 'valign' => 'top'),
				array('data' => $item->create_date, 'valign' => 'top'),
		);
	}

	$output .= theme('table', array("header" => $header, "rows" => $rows));
	return $output;
}


function package_tour_admin_transaction_detail($ref_code){

	$output = "";
	
	$query = db_select('thtt_t_reservation','t');
	$query->leftJoin('thtt_t_reservation_detail', 'd', 't.rsvn_id = d.rsvn_id');
	$query->fields('t')
	->fields('d');
	//->fields('ty', array('type_name'));
	//$query->addField('d1', 'dest_name', 'dest_from_name');
	//$query->addField('d2', 'dest_name', 'dest_to_name');
	
	if($ref_code != ""){
		$query->condition('t.rsvn_id', $ref_code);
	}
	
	$query->orderBy('t.rsvn_ref', 'DESC');
	$result = $query->execute();
	
	$header = array(t(' '), t(' '));

	$options= array();
	$options['attributes']['target'] = '_blank';
	$options['html'] = TRUE;
	
	$output .= l('<input type="button" value="Export PDF" class="form-submit"/>', "admin/config/content/package_tour/transaction/detail/$ref_code/pdf", $options );

	foreach($result as $item) {
			
		$status = "";
		if($item->rsvn_status == 1){
			$status = "Unpaid";
		}else if($item->rsvn_status == 2){
			$status = "Paid";
		}
	
		$rows[] = array(
				array('data' => t('Ref code'), 'valign' => 'top'),
				array('data' => $item->rsvn_ref, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('IP Address'), 'valign' => 'top'),
				array('data' => $item->rsvn_ip, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Customer name'), 'valign' => 'top'),
				array('data' => $item->rsvn_guest_title.$item->rsvn_guest_fname.' '.$item->rsvn_guest_lname, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Nationality'), 'valign' => 'top'),
				array('data' => $item->rsvn_nationality, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Tel'), 'valign' => 'top'),
				array('data' => $item->rsvn_tel, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Email'), 'valign' => 'top'),
				array('data' => $item->rsvn_email, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Travel Date'), 'valign' => 'top'),
				array('data' => $item->rsvn_travel_date, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Tour name'), 'valign' => 'top'),
				array('data' => $item->tour_name, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Program'), 'valign' => 'top'),
				array('data' => $item->prog_name, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Number of Adult'), 'valign' => 'top'),
				array('data' => 'Adult: '.$item->rsvn_adult.', Child: '.$item->rsvn_child.', Infant: '.$item->rsvn_infant, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Total price'), 'valign' => 'top'),
				array('data' => $item->rsvn_price_total." ".$item->currency_cd, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Booking No'), 'valign' => 'top'),
				array('data' => $item->rsvn_booking_no, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Pickup - Dropoff'), 'valign' => 'top'),
				array('data' => 'Pickup: '.$item->rsvn_pickup.' Dropoff: '.$item->rsvn_dropoff, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Hotel'), 'valign' => 'top'),
				array('data' => $item->rsvn_hotel.", room: ".$item->rsvn_rooms, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Checkin - Checkout'), 'valign' => 'top'),
				array('data' => "Check-in: ".$item->rsvn_checkin." Check-out: ".$item->rsvn_checkout, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Arrival flight'), 'valign' => 'top'),
				array('data' => $item->rsvn_arr_flight." (Date: ".$item->rsvn_arr_date." ".$item->rsvn_arr_time.")", 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Depart flight'), 'valign' => 'top'),
				array('data' => $item->rsvn_dep_flight." (Date: ".$item->rsvn_depart_date." ".$item->rsvn_dep_time.")", 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Ref code'), 'valign' => 'top'),
				array('data' => $item->rsvn_special_request, 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Status'), 'valign' => 'top'),
				array('data' => t($status), 'valign' => 'top')
		);
		$rows[] = array(
				array('data' => t('Create date'), 'valign' => 'top'),
				array('data' => $item->create_date, 'valign' => 'top')
		);
	}
	
	$output .= theme('table', array("header" => $header, "rows" => $rows));
	
	return $output;
}


function package_tour_admin_transaction_detail_pdf ( $ref_code) {

	$output =	package_tour_admin_transaction_detail($ref_code);
	
	$fb_lib_path = function_exists('libraries_get_path') ? libraries_get_path('tcpdf') : 'sites/all/libraries/tcpdf';
	$fb_platform = $fb_lib_path . '/tcpdf.php';
	try {
		if (!class_exists('TCPDF') && !@include($fb_platform)) {
			//show error
			return NULL;
		}

		define('K_TCPDF_EXTERNAL_CONFIG', true);
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		//$pdf->SetHeaderData(PDF_HEADER_IMAGE, PDF_HEADER_IMAGE_WIDTH);
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		//$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		//$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM+20);
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);


		$pdf->SetPrintHeader(false);
		$pdf->SetPrintFooter(false);

		// set some language-dependent strings (optional)
		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
			require_once(dirname(__FILE__).'/lang/eng.php');
			$pdf->setLanguageArray($l);
		}

		// 	 		$logo=base_url('assets/images/logo.jpg');

		// add a page
		$pdf->AddPage();
		$pdf->SetFont( 'angsanaupc' , '', 14, '', true);
			
		$pdf->writeHTML($output, true, false, false, false, '');


		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		$pdf->Output('custinvoice_finance.pdf', 'I');
			

	}
	catch (Exception $e) {}

	//return $output;
}





function _exchange_thaihappy_admin_rate_copy($src_booth_cd, $copy_booth_cd){
    
    global $user;
    global $base_url;
    $output = "";
    
    //Keep History
    //---- Add History Master ---------
    $master_id = db_insert('thtt_exchange_t_rate_current_branch_master') // Table name no longer needs {}
    ->fields(array(
        'booth_cd' => $src_booth_cd,
        'curr_date' => date("Y-m-d H:i:s", time()),
        'curr_time_id' => 0,
        'create_by' => $user->uid,
        'create_dttm' => date("Y-m-d H:i:s", time())
    ))
    ->execute();
    
    
    // Get copy booth
    $query = db_select('thtt_exchange_m_currency_branch','a');
    $result = $query
    ->fields('a')
    ->condition('a.booth_cd',$copy_booth_cd)
    ->execute();
    
    foreach($result as $item) {
        $currency_name = $item->currency_name;
        $buy_price = $item->rate_buy;
        $sell_price = $item->rate_sell;
        
        if($buy_price != ""){
            if($sell_price==""){
                $sell_price = "0.0";
            }
            
            $query3 = db_query("
                                    select count(*) as count_trns from thtt_exchange_m_currency_branch m
                                    where m.booth_cd = '$src_booth_cd'
                                    and m.currency_id = '$item->currency_id'
                            		");
            
            $result3 = $query3->fetchAll();
            $chkZero = 0;
            foreach ($result3 as $item3) {
                 $chkZero = $item3->count_trns;
            }
            
            if($chkZero> 0){
                $nid = db_update('thtt_exchange_m_currency_branch')
                ->fields(array(
                    'rate_buy' => $buy_price,
                    'rate_sell' => $sell_price,
                    'update_by' => $user->name,
                    'update_dttm' => date("Y-m-d H:i:s", time())
                ))
                ->condition('booth_cd', $src_booth_cd)
                ->condition('currency_id', $item->currency_id)
                ->execute();
            }else{
                $nid = db_insert('thtt_exchange_m_currency_branch')
                ->fields(array(
                    'currency_id' => $item->currency_id,
                    'booth_cd' => $src_booth_cd,
                    'currency_name' => $item->currency_name,
                    'currency_default' => $item->currency_default,
                    'rate_buy' => $buy_price,
                    'rate_sell' => $sell_price,
                    'create_by' => $user->name,
                    'create_dttm' => date("Y-m-d H:i:s", time()),
                    'update_by' => $user->name,
                    'update_dttm' => date("Y-m-d H:i:s", time())
                ))
                ->execute();
            }
            
            //---- Add History Detail ---------
            $detail_id = db_insert('thtt_exchange_t_rate_current_branch')
            ->fields(array(
                'rate_current_branch_master_id' => $master_id,
                'currency_id' => $item->currency_id,
                'currency_name' => $item->currency_name,
                'buy_price' => $buy_price,
                'sell_price' => $sell_price,
                'rate_dttm' => date("Y-m-d H:i:s", time()),
                'create_by' => $user->uid,
                'create_dttm' => date("Y-m-d H:i:s", time()),
                'update_by' => $user->uid,
                'update_dttm' => date("Y-m-d H:i:s", time())
            ))
            ->execute();
            
        }
    }
    

    drupal_set_message(t('Currency rate has changed.'));
    drupal_goto("$base_url/admin/config/content/exchange_thaihappy/admin/rate/add_booth/".$src_booth_cd);
    return  $output;
}



function _exchange_thaihappy_admin_setting_discount(){
    
    global $user;
    global $base_url;
    
    $docNo = "";
    $output = "";

    
    //******* Start HTML *********
    
    //--------- Style sheet ------
    $output .= '<link rel="stylesheet" type="text/css" media="all" href="'.$base_url.'/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';
    
    //--------- Javascript ----------
    $output .= '
	<script type="text/javascript">
            
    	function checkSubmit(){
    			return true;
    	}

         $(function() {
            $( "#viewRateDialog" ).dialog({
               autoOpen: false,  
            });
            $( ".view-rate" ).click(function() {
               $( "#viewRateDialog" ).dialog( "open" );
            });
         });
      </script>

	';
    
    //------------ Content ----------------
    $output .='	<form id="exchangeFrm" method="POST" onsubmit="return checkSubmit()" action="'.$base_url.'/admin/config/content/exchange_thaihappy/admin/setting_discount/submit">';
    $output .='<div class="col-md-12 col-sm-12">
	<h2>Update discount selling rate</h2>
	</div>';
    
    $output .='<div class="col-md-12 col-sm-12"></div>';
    
    //-------------- Detail ------------------
    $output .= '<div class="col-md-12 col-sm-12 desc-panel-buying">';
    
    $output .= '
	<div class="col-md-12 col-sm-12">&nbsp;</div>
	<table style="background-color:#fff;">
	<thead>
	<tr  style="background-color:#eeeeee">
	<th>Country</th>
	<th>Currency</th>
	<th>Discount sell rate <div style="font-size:xx-smll; color:#888888; font-weight:normal; font-size: small; ">(will be decreased from currency rate)</div> </th>
	<th>Operation</th>
	</tr>
	</thead>
	<tbody>';
    
    
    $result = db_select('thtt_exchange_m_currency','a')
    ->fields('a')
    ->condition("currency_default","N")
    ->execute();
    
    foreach($result as $item) {
        $output .= "
						<tr>
						<td>$item->country</td>
						<td>$item->currency_name <input type='hidden' name='curr[]' value='$item->currency_id' /></td>
						<td><input type='text' name='discount_rate[]' class='form-entry' value='$item->sell_discount_rate'/></td>
						<td><div class='view-rate' style='cursor:pointer;'>View Rate</div></td>
						</tr>";
    }
    
    $output .= '
	</tbody>
	</table>
	';
    
    $output .= '</div>';
    
    $output .= '<div class="col-md-12 col-sm-12 form-entry">
	<input type="submit" class="btn btn-success" name="save" value="Save" style="width:100%; font-size:24px; padding:10px; margin-bottom:20px; ">
	</div>';
    
    $output .= '</form>';
    
    $output .='<div id="viewRateDialog">'; 
    
    
    $result = db_select('thtt_exchange_m_booth','a')
    ->fields('a')
    ->condition("is_enable",'Y')
    ->execute();
    
    $output .='<div class="col-md-12 col-sm-12">
                        	<h3>View Rate</h3>
                    	</div>';
    
    $output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';
    
    foreach($result as $item) {
        $output .= '<a class="col-md-12 col-sm-12" href="'.$base_url.'/exchange_thaihappy/rate_list/'.$item->booth_cd.'" target="_blank">'.$item->booth_name.'</a>';
    }
    $output .= '</div>';
    
    return $output;
}


function _exchange_thaihappy_admin_setting_discount_submit() {
    global $user;
    global $base_url;
    $output = "";
    
    for($i=0; $i<count($_POST['curr']); $i++){
        $curr = $_POST['curr'][$i];
        $sell_discount_rate = $_POST['discount_rate'][$i];

        if($sell_discount_rate != ""){
            $nid = db_update('thtt_exchange_m_currency') // Table name no longer needs {}
            ->fields(array(
                'sell_discount_rate' => $sell_discount_rate,
                'update_by' => $user->name,
                'update_dttm' => date("Y-m-d H:i:s", time())
            ))
            ->condition('currency_id', $curr)
            ->execute();
        }
    }

    drupal_set_message(t('Currency discount rate has been changed.'));
    drupal_goto("$base_url/admin/config/content/exchange_thaihappy/admin/setting_discount");
    return  $output;
}


