<?php

function _exchange_thaihappy_check_auth(){
	global $user;
	global $base_url;
	$contentHTML = "";
	
	if ( !$user->uid ) {
		unset($_SESSION["booth_cd"]);
		drupal_goto("$base_url/user/login");
	}
	
// 	if(isset($_SESSION["booth_cd"])){
// 		drupal_goto("$base_url/admin/config/content/exchange_thaihappy/shop");
// 	}
	
	$query = db_select('users_roles','ur');
	$query->join("role", "r", "r.rid = ur.rid");
	$result = $query
	->fields('r')
	->condition('ur.uid',$user->uid)
	->execute();
	
	$chkUserPermission = false;
	$chkAccPermission = false;
	$chkAdminPermission = false;
	foreach($result as $item) {
		if($item->name == "Exchange user"){
			$chkUserPermission = true;
		}else if($item->name == "Exchange acc user"){
			$chkAccPermission = true;
		}else if($item->name == "Exchange admin user"){
			$chkAdminPermission = true;
		}
	
		break;
	}
	
	
	if($chkUserPermission) {
		unset($_SESSION["booth_cd"]);
		drupal_goto("$base_url/admin/config/content/exchange_thaihappy/setting_default");
		$chkNoPermission = false;
	}
	
	if($chkAccPermission) {
		drupal_goto("$base_url/admin/config/content/exchange_thaihappy/acc");
		$chkNoPermission = false;
	}

	if($chkAdminPermission) {
			drupal_goto("$base_url/admin/config/content/exchange_thaihappy/shop");
		$contentHTML = "<script>window.location.href = '$base_url/admin/config/content/exchange_thaihappy'; </script>";
		$chkNoPermission = false;
	}
	
	if($chkNoPermission){
			drupal_goto("$base_url/admin/config/content/exchange_thaihappy/shop");
		$contentHTML = "<script>window.location.href = '$base_url/admin/dashboard'; </script>";
	}

	return $contentHTML;
}

function exchange_thaihappy_admin_view() {
	$output = "";

	$header = array(t('Mangement Menu'), t('Operations'));
	$rows[] = array(
			array('data' => t('Exchange Transactions'), 'valign' => 'top'),
			array(
					'data' =>
					l(t('View transaction'), 'admin/config/content/exchange_thaihappy/shop/report')
					. ' | '.
					l(t('Add new transaction'), 'admin/config/content/exchange_thaihappy/shop/add')
					,
					'valign' => 'top'
			)
	);

	$rows[] = array(
			array('data' => t('Exchange Rate Management'), 'valign' => 'top'),
			array(
					'data' =>
					l(t('List'), 'admin/config/content/exchange_thaihappy/rate/list') . ' | '.
					l(t('Add new rate'), 'admin/config/content/exchange_thaihappy/rate/add') ,
					'valign' => 'top'
			)
	);

	$output .= theme('table', array("header" => $header, "rows" => $rows));
	return $output;
}


/**************************************************************************************
 *       							Shop first page
 **************************************************************************************/
function _exchange_thaihappy_shop(){

	$output = "";

	//---- Start HTML output -----
	$output .='<div class="col-md-12 col-sm-12">
					<h3>Exchange Menu</h3>
				</div>';
	
	$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';
		
	$output .= l('<input type="button" value="New Buy Transaction" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/shop/buyadd', array('html' => TRUE, ));
	$output .= l('<input type="button" value="New Sell Transaction" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/shop/selladd', array('html' => TRUE, ));
	$output .= l('<input type="button" value="My Transactions" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/shop/transactions', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Summary Report Today" class="btn btn-exchange col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/shop/report_today', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Setup Exchange Branch" class="btn btn-exchange  col-md-6 col-sm-12"/>', 'admin/config/content/exchange_thaihappy/setting_default', array('html' => TRUE, ));
	$output .= l('<input type="button" value="Logout" class="btn btn-exchange  col-md-6 col-sm-12"/>', 'user/logout', array('html' => TRUE, ));
	
	
	return $output;
}

function _exchange_thaihappy_shop_report_today(){
	
	global $user;
	global $base_url;
	$output = "";
	
	//******* Start HTML *********
	
	//--------- Style sheet ------
	$output .= '<link rel="stylesheet" type="text/css" media="all" href="'.$base_url.'/sites/all/themes/custom/scratch/CSS/exchange.frm.css" />';
	
	//--------- Javascript ----------
	$ajaxCalRowTotalUrl = $base_url."/admin/config/content/exchange_thaihappy/shop/report_today_excel";
	$output .= '
	<script type="text/javascript">
	$(document).ready(function(){
	
	var dateToday = new Date();
	var dates = $("#inDate, #outDate").datepicker({
	changeMonth: true,
	numberOfMonths: 1,
	dateFormat: \'yy-mm-dd\',
	onSelect: function(selectedDate) {
	var option = this.id == "inDate" ? "minDate" : "maxDate",
	instance = $(this).data("datepicker"),
	date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
	dates.not(this).datepicker("option", option, date);
	}
	});
	});
	</script>
	';
	
	//------------ Content ----------------
	$output .='<div class="col-md-12 col-sm-12">
	<h2>'.t("Search Transactions").'
	</div>';
	
	$output .= '<div class="col-md-12 col-sm-12">&nbsp;</div>';
	
	
	//-------------- Search Results ------------------
	$output .= '<div class="col-md-12 col-sm-12 desc-panel">';
	$output .='<div class="col-md-12 col-sm-12">
	Search Form
	</div>';
	
	$output .='	<form id="" method="POST" action="'.$ajaxCalRowTotalUrl.'" target="">';
	
	$output .='<div class="col-md-8 col-sm-12 form-label">
	Transaction Date : <input id="inDate" name="inDate" type="text"
	value="" readonly="readonly"
	style="width: 40%; cursor: pointer;">
	</div>';
	
	$output .='<div class="col-md-4 col-sm-12">
	<col-md-12 col-sm-12 form-entry text-left">
	<input type="reset" class="btn btn-default" value=" Clear Search ">
	<input id="search" name="search" type="submit" class="btn btn-primary add-row" value=" Export to Excel ">
	</div>
	</div>';
	
	$output .='<input name="mode" type="hidden" value="shop">';
	
	$output .= '</form>';
	$output .= "<iframe id='act' name='act' style='display:none'></iframe>";
	$output .= '</div>';
	
	return $output;
}


function _exchange_thaihappy_shop_report_today_excel_result(){
	global $user;
	global $_SESSION;

	$trns_date = $_POST['inDate'];

	$fb_lib_path = function_exists('libraries_get_path') ? libraries_get_path('PHPExcel-1.8') : 'sites/all/libraries/PHPExcel-1.8';
	$fb_platform = $fb_lib_path . '/Classes/PHPExcel.php';
	
	try {
		require_once $fb_platform;
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user->name)
		->setLastModifiedBy($user->name)
		->setTitle("Summary Exchange Report Today")
		->setSubject("Summary Exchange Report Today")
		->setDescription("Summary Exchange Report Today")
		->setKeywords("office 2007 openxml php")
		->setCategory("Summary Exchange Report");

		// Get DB
		$shopWhere= " AND m.booth_cd = '".$_SESSION["booth_cd"]."'  ";

		$query = db_query("select m.trns_type, date(m.trns_dttm), m.booth_cd, m.booth_name, d.currency_id, d.currency_name, d.unit_price
				, SUM(d.amount) as amount, SUM(d.total) as total
				from thtt_exchange_t_transaction_master m
				inner join thtt_exchange_t_transaction_detail d ON m.trns_master_id = d.trns_master_id
				WHERE m.flag_cancel = 'N'  and m.trns_type = 'BUYING' and date(m.trns_dttm) = '$trns_date' $shopWhere
				GROUP BY m.trns_type, date(m.trns_dttm), m.booth_cd, m.booth_name, d.currency_id, d.currency_name, d.unit_price
				ORDER BY m.booth_cd, d.currency_name
				");

		// Add some data
		$style = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				)
		);
		$style_left = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
				)
		);
		$style_right = array(
				'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT,
				)
		);
		$style_border = array(
				'borders' => array(
						'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_THIN
						)
				)
		);
		$style_border_solid = array(
				'borders' => array(
						'allborders' => array(
								'style' => PHPExcel_Style_Border::BORDER_MEDIUM
						)
				)
		);

		$boothCD = "";
		$sheetIndex = -1;
		$firstRec = true;
		$buyTotal = 0;
		$lastIndex = 0;

		$result = $query->fetchAll();
		foreach ($result as $item) {
				
			if($boothCD != $item->booth_cd){
				if($firstRec){
					$firstRec = false;
				}else{
					//Set Footer of last sheet
					$lastIndex = $rowIndex;
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A6:I".$lastIndex)->applyFromArray($style_border);
						
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'รวมยอดรับซื้อ')
					->setCellValue('E'.$rowIndex, 'ยอดขาย')
					->setCellValue('D'.$rowIndex, $buyTotal);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A'.$rowIndex.":I".$rowIndex)->applyFromArray($style_border_solid);
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'ยอดยกมา');
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'ยอดเบิกเงินเพิ่ม')
					->setCellValue('E'.$rowIndex, 'ยอดเงินรับซื้อจริง');
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'รวมเป็นเงิน')
					->setCellValue('E'.$rowIndex, 'ยอดจากเลจที่ถูกต้อง');
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'หัก รวมยอดเงินรับซื้อ')
					->setCellValue('E'.$rowIndex, 'สรุปให้เลจผิดเกิน');
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'ยอดเงินตามเอกสาร')
					->setCellValue('E'.$rowIndex, 'สรุปเงินเกินจากยอดสรุป');
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'ยอดเงินที่นับได้จริง');
					$rowIndex++;

					$objPHPExcel->setActiveSheetIndex($sheetIndex)
					->setCellValue('A'.$rowIndex, 'ยอดเกิน');
						
					$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A".($lastIndex+1).":G".$rowIndex)->applyFromArray($style_border);
					//End Set Footer od last sheet
				}

				$buyTotal = 0;
				$boothCD = $item->booth_cd;
				$sheetIndex = $sheetIndex+1;
				$rowIndex = 8;

				//SET AUTO width
				// 				foreach(range('A','I') as $columnID) {
				// 					$objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
				// 					->setAutoSize(true);
				// 				}
				$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25);
				$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
				$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);

				$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A2:I7")->applyFromArray($style);
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("I4")->applyFromArray($style_right);
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("B8:I99")->applyFromArray($style_right);

				$objPHPExcel->getActiveSheet()->getStyle('A6:I99')->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A2:I2');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)
				->setCellValue('A2', 'สรุปยอดการรับซื้ออัตราแลกเปลี่ยนเงินตราต่างประเทศ')
				->setCellValue('A4', 'ยอดประจำวันที่')
				->setCellValue('C4', $trns_date)
				->setCellValue('I4', $item->booth_name);
					
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('A6:A7');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('B6:C6');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D6:D7');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('D6:D7');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E6:F6');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('G6:G7');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('H6:H7');
				$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('I6:I7');
					
				$objPHPExcel->setActiveSheetIndex($sheetIndex)
				->setCellValue('A6', 'สกุลเงิน')
				->setCellValue('B6', 'ยอดรับซื้อ')
				->setCellValue('B7', 'รับซื้อ')
				->setCellValue('D6', 'ยอดรวม')
				->setCellValue('E6', 'ยอดนำส่ง')
				->setCellValue('E7', 'ขาย')
				->setCellValue('F7', 'เลจ')
				->setCellValue('G6', 'ยอดรวม')
				->setCellValue('H6', 'กำไร')
				->setCellValue('I6', 'ยกไป');
					
				// Rename worksheet
				$objPHPExcel->getActiveSheet()->setTitle($item->booth_cd);
			}
			$buyTotal += $item->total;
			$objPHPExcel->setActiveSheetIndex($sheetIndex)
			->setCellValue('A'.$rowIndex, $item->currency_name)
			->setCellValue('B'.$rowIndex, $item->amount)
			->setCellValue('C'.$rowIndex, $item->unit_price)
			->setCellValue('D'.$rowIndex, $item->total );

			$rowIndex++;
		}

		//Set Footer of last sheet
		$lastIndex = $rowIndex;
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A6:I".$lastIndex)->applyFromArray($style_border);

		$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'รวมยอดรับซื้อ')
		->setCellValue('E'.$rowIndex, 'ยอดขาย')
		->setCellValue('D'.$rowIndex, $buyTotal);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('A'.$rowIndex.":I".$rowIndex)->applyFromArray($style_border_solid);
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'ยอดยกมา');
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'ยอดเบิกเงินเพิ่ม')
		->setCellValue('E'.$rowIndex, 'ยอดเงินรับซื้อจริง');
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'รวมเป็นเงิน')
		->setCellValue('E'.$rowIndex, 'ยอดจากเลจที่ถูกต้อง');
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'หัก รวมยอดเงินรับซื้อ')
		->setCellValue('E'.$rowIndex, 'สรุปให้เลจผิดเกิน');
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->mergeCells('E'.$rowIndex.':F'.$rowIndex);
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'ยอดเงินตามเอกสาร')
		->setCellValue('E'.$rowIndex, 'สรุปเงินเกินจากยอดสรุป');
		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle('E'.$rowIndex)->applyFromArray($style_left);
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'ยอดเงินที่นับได้จริง');
		$rowIndex++;
			
		$objPHPExcel->setActiveSheetIndex($sheetIndex)
		->setCellValue('A'.$rowIndex, 'ยอดเกิน');

		$objPHPExcel->setActiveSheetIndex($sheetIndex)->getStyle("A".($lastIndex+1).":G".$rowIndex)->applyFromArray($style_border);
		//End Set Footer od last sheet



		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);


		// Redirect output to a client
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="SummaryReport_'.$trns_date.'.xlsx"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the followsing may be needed
		header('Cache-Control: max-age=1');

		// If you're serving to IE over SSL, then the following may be needed
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
		header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header ('Pragma: public'); // HTTP/1.0

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;
	}catch (Exception $e) {
	}

}




/**************************************************************************************
 *       							Shop setting default before working
 **************************************************************************************/
function exchange_thaihappy_shop_setting_default() {

	global $base_url;
		$output = "";
		
		if(isset($_POST['save']) && isset($_POST['booth_cd'])){
			
			$_SESSION["booth_cd"] = $_POST['booth_cd'];
			
			// Print a 'OK' message
			drupal_set_message(t('Exchange Setting saved'));
			drupal_goto("$base_url/admin/config/content/exchange_thaihappy/shop");
			return $output;
		}
		
		if(isset($_SESSION["booth_cd"])){
			$booth_cd = $_SESSION["booth_cd"];
		}else{
			$booth_cd = "";
		}
		
		// Build the form
			$result = db_select('thtt_exchange_m_booth','a')
			->fields('a')
			->orderBy("booth_name","ASC")
			->execute();
			
			$boothOption = '<select name="booth_cd" class="form-control" style="width:70%;">';
			foreach($result as $item) {
				$chk = "";
				if($booth_cd==$item->booth_cd){
					$chk = " selected='selected' ";
				}
				$boothOption .= '<option value="'.$item->booth_cd .'" '.$chk.'>'.$item->booth_name.'</option>';
			}
			$boothOption .= '</select>';
			
			
			//---- Start HTML output -----
			$output .= '<div class="form-corner">';
			$output .='<div class="col-md-12 col-sm-12">
					<h1>Setup Exchange Branch</h1>
				</div>';

			$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';
			
			$output .='	<form method="POST">';
			$output .='<div class="col-md-12 col-sm-12">
									<div class="col-md-6 col-sm-12 form-label">
										Working Booth:
									</div>
									<div class="col-md-6 col-sm-12 form-entry">
										'.$boothOption.'
									</div>
							</div>
				';
			$output .= '<div class="col-md-12 col-sm-12 label-desc">Select booth branch before working today</div>';

			$output .= '<HR class="col-md-12 col-sm-12" style="border: 1px dashed #000;"/>';
			$output .='
				<div class="col-md-12 col-sm-12">
							<input type="submit" class="btn btn-primary add-row" name="save" value="Save and continue working">
				</div>';
			
			$output .= '<div class="col-md-12 col-sm-12"></div>
					
			    </form>';

			$output .= '</div>';
			
			return $output;
}










function _exchange_thaihappy_list_item($argument1) {
	
	$titlePage = "";
	$contentHTML = "";
	
	$query = db_select('url_alias','t');
	$query->fields('t')
	->condition('t.alias',$argument1);
	$result = $query->execute();
	
	foreach($result as $item) {
		$sourceArr = explode("/", $item->source);
		$nid = $sourceArr[1];
			
		$query2 = db_select('thtt_m_tour','t');
		$query2->join('thtt_m_tour_category', 'c', 't.tour_category_id = c.tour_category_id');
		$query2->fields('t')
		->condition('t.nid',$nid)
		->condition('t.is_enable','Y')
		->range(0, 1);
		$result2 = $query2->execute();
		
		$tourItem = null;
		foreach($result2 as $item2) {
			$tourItem = $item2;
			$titlePage = $tourItem->tour_name;
			
			// load node
			$nodeLoad = node_load($tourItem->nid);
		}
	}

	$contentHTML .= '<div class="col-md-12 col-sm-12"><a href="">Home</a> > <a href="/package-tours"> Tour Packages</a> > <b>'.$tourItem->tour_name.'</b> </div>';
	//$contentHTML .= '<div style="margin-top: 50px;"></div>';
	$contentHTML .= '<div class="container">';
	$contentHTML .= '<article id="main" class="col-md-10 col-sm-12">';
	$contentHTML .= '<div style="margin-top:20px;">';
	$contentHTML .= $tourItem->tour_short_desc;
	$contentHTML .= '</div>';
	$contentHTML .= '<center>';
	
	try{
		if($tourItem->tour_picture_path != 0 && $tourItem->tour_picture_path != ""){
			$img = file_create_url(file_load($tourItem->tour_picture_path)->uri);
		}else{
			$img = "";
		}
	}catch (Exception $e) {
		$img = "";
	}
	
	if($img != ""){
		$variables = array(
				'path' => $img,
				'alt' => '',
				'title' => '',
				'width' => '100%',
				'height' => '',
				'attributes' => array('class' => 'tour-img-item')
		);
		$contentHTML .= theme('image', $variables);
	}else{
		$contentHTML .= "<div class='home-item-no-photo'></div>";
	}
	
	
	$contentHTML .= '<div class="col-md-12 booking-panel">';
	
	$query = db_select('thtt_m_program','t');
	$query->fields('t')
	->condition('t.tour_id', $tourItem->tour_id);
	
	$result = $query->execute();
	$tourItem = null;
	
	foreach($result as $item) {
		$contentHTML .= '<div class="col-md-12 booking-panel-item">';
		$contentHTML .= '<div class="col-md-5 col-sm-12" style="color:#0072A7;font-size:14px;font-weight:bold;">'. $item->prog_name .'</div>';
		$contentHTML .= '<div class="col-md-5 col-sm-12" >';
		$contentHTML .= '<div class="col-md-12 price" style="text-decoration:line-through; color:#333; font-weight:normal;">Adult: THB '. number_format($item->price_adult,0) .' / Child: THB '. number_format($item->price_child,0) .'</div>';
		$contentHTML .= '<div class="col-md-12"  style="color:red;font-size:14px;font-weight:bold;">Adult: THB '. number_format($item->price_new_adult,0) .' / Child: THB '. number_format($item->price_new_child,0) .'</div>';
		$contentHTML .= '</div>';
		$contentHTML .= '<div class="col-md-2 col-sm-12"><a class="btn btn-booking" href="javascript:;" onclick="makebooking('. $item->prog_id .');">Make Booking!</a></div>';
		$contentHTML .= '</div>';
	}
	
	$contentHTML .= '</div>';
	$contentHTML .= '</center>';
	$contentHTML .= '<div id="bodycontent" class="col-md-12 my-container">';
	$contentHTML .= '<style scoped>@import "sites/all/modules/ckeditor/content.css"; </style>';
	$contentHTML .= render($nodeLoad->body['und'][0]['value']);
	
	//********* Comments ****************
	$contentHTML .= "<HR/>";
	$contentHTML .= "<h2 style='margin-top:50px; position:relative;'> Reviews </h2>";
	
	$queryComment = db_select('node','n');
	$queryComment->join('comment', 'c', 'n.nid=c.nid');
	$queryComment->join('field_data_comment_body', 'b', 'b.entity_id=c.cid');
	$queryComment->fields('c')
							->fields('b')
	->condition('n.nid',$nid);
	$resultComment = $queryComment->execute();
	
	foreach($resultComment as $itemComment) {
		$contentHTML .= "<div class='col-md-12 col-sm-12' style='border:1px dashed #646464; position:relative; padding: 20px;'>";
		$contentHTML .= "<h3 style='color:#003663;'>{$itemComment->subject}</h3>";

		$contentHTML .= "<div class='col-md-12 col-sm-12' style='font-size:14px; color:#AAA;'><b>name :</b> {$itemComment->name} <b>Created :</b> {$itemComment->created}</div>";
		
		$contentHTML .= "<div style='position:relative;'>{$itemComment->comment_body_value}</div>";
		$contentHTML .= "</div>";

		$contentHTML .= "<HR/>";
	}
	

	$contentHTML .= "<HR style='margin-top:20px; position:relative;'/>";

	$contentHTML .= "<div class='col-md-12 col-sm-12' style='background-color:#eee; margin-top:30px; padding-top:10px;'>";
	$contentHTML .= "<h4>Add your review</h4>";
	$contentHTML .= drupal_render(drupal_get_form("comment_node_{$nodeLoad->type}_form", (object) array('nid' => $nodeLoad->nid)));
	
	$contentHTML .= "</div>";
	
	
	$contentHTML .= "<HR/>";
	
	$contentHTML .= '</div>';
	$contentHTML .= '</article>';
	

// 	//<!-- ****************	License ****************** -->
// 	$contentHTML .= '<div class="ads-content col-md-2 col-sm-12">';
// 	$contentHTML .= '<ul>';
// 	$contentHTML .= '<li>';
// 	$variables = array(
// 			'path' => 'images/best_price.png',
// 			'alt' => 'Best price',
// 			'title' => 'Best price',
// 			'width' => '',
// 			'height' => '',
// 	);
// 	$contentHTML .= theme('image', $variables);
// 	$contentHTML .= '</li>';
// 	$contentHTML .= '<li>';
// 	$variables = array(
// 			'path' => 'images/ttt.png',
// 			'alt' => '',
// 			'title' => '',
// 			'width' => '',
// 			'height' => '',
// 	);
// 	$contentHTML .= theme('image', $variables);
// 	$contentHTML .= '<BR /> <BR /> TAT Licence 31 / 00904</li>';
// 	$contentHTML .= '</ul>';
// 	$contentHTML .= '</div>';

	$contentHTML .= '</div>';
	$contentHTML .= '<div class="dash-line"></div>';
	$contentHTML .= '<script>';
	$contentHTML .= 'function makebooking(id){';
	$contentHTML .= '	window.location.href = "'.$GLOBALS['base_url'].'/booking?p="+id;';
	$contentHTML .= '}';
	$contentHTML .= '</script>';
	
	drupal_set_title($titlePage);
	
	$page_keywords = array(
			'#type' => 'html_tag',
			'#tag' => 'meta',
			'#attributes' => array(
					'name' => 'keywords',
					'content' => $titlePage,
			)
	);
	drupal_add_html_head($page_keywords, 'page_keywords');
	
	
  return $contentHTML;
}


